<?php

namespace App;
use DB;
use Illuminate\Database\Eloquent\Model;

class Address extends Model
{
    public static function GetAddressbyPostcode($Postcode)
    {
      $PostcodeSql = str_replace('+','', $Postcode);
      $strRaw = "REPLACE(`postcode`,' ','') = ?";
      $AddressInfo = DB::table('address')
      ->whereRaw($strRaw, $PostcodeSql)
      ->orWhere('postcode', $PostcodeSql)
      ->first();
      return $AddressInfo;
    }
    public static function GetAddressbyID($AddressID)
    {
        $AddressInfo = DB::table('address')->where('id', $AddressID)->first();
        return $AddressInfo;
    }

    public static function InsertAddress($data = null)
    {
        if (!empty($data)) {
            $AddressInfo = DB::table('address')->insert($data);
            $ID = DB::getPdo()->lastInsertId();
            return $ID;
        }
    }

    public static function GetAllIn($array = null, $indexKey = false)
    {
      if(empty($array)) return null;
        $fixedArray = array_filter(array_unique($array));
        $AllAddresses = DB::table('address')->whereIn('id', $fixedArray)->get();
        if(!empty($indexKey)){
          if(!empty($AllAddresses)){
            $NewArray = null;
            foreach($AllAddresses as $address){
              $NewArray[$address->id] = $address;
            }
            return $NewArray;
          }
        }
        return $AllAddresses;
    }

    public static function UpdateAddress($AddressID = 0, $data = null)
    {
        if (!empty($data)) {
            $Update = DB::table('address')->where('id', $AddressID)->update($data);
            return $Update;
        }
    }
}
