<?php

namespace App\Http\Controllers;

use App\Address;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Cache;

class AddressController extends Controller
{
    public function getByID($id = 0)
    {
        if (!empty($id)) {
            $results = Address::GetAddressbyID($id);
            print_r($results);
        }
    }

    public function getGoogleAddressbyPostcode($postcode = '')
    {
        if (!empty($postcode)) {
          $GoogleKey = env('GOOGLE_API_KEY');
          $urlPostcode = urlencode($postcode);
          $url = "https://maps.googleapis.com/maps/api/geocode/json?address=$urlPostcode&key=$GoogleKey";
          $json = file_get_contents($url);
          $results = json_decode($json);
          print_r($results);
        }
    }

    public function getAddressGoogle(request $request)
    {
        if (!empty($request->code)) {
          $GoogleKey = env('GOOGLE_API_KEY');
          $houseNumber = urlencode($request->hn);
          $urlPostcode = urlencode($request->code);
          $str = (!empty($houseNumber)) ? "$houseNumber,$urlPostcode" : $urlPostcode;
          $this->TempAddrUrl = "https://maps.googleapis.com/maps/api/geocode/json?address=$str&key=$GoogleKey";
          $results = Cache::rememberForever($this->TempAddrUrl, function() {
            $json = file_get_contents($this->TempAddrUrl);
            return json_decode($json);
          });
          if(empty($results->results[0]->address_components)) return null;
          $ReturnAddress = (object) array();
          $addressComponents = $results->results[0]->address_components;
          $ReturnAddress->Street = $this->getLocation($addressComponents, 'route');
          $ReturnAddress->area = $this->getLocation($addressComponents, 'locality');
          $ReturnAddress->town = $this->getLocation($addressComponents, 'postal_town');
          $ReturnAddress->county = $this->getLocation($addressComponents, 'administrative_area_level_2');
          $ReturnAddress->postcode = $this->getLocation($addressComponents, 'postal_code');
          header('Content-Type: application/json');
          echo json_encode($ReturnAddress);
        }
    }


    public function getByPostcode($postcode = '')
    {
        if (!empty($postcode)) {
          $results = Address::GetAddressbyPostcode($postcode);

          print_r($results);
        }
    }

    public function Insert(Request $request)
    {
        if (!empty($request->input('postcode'))) {
            $data = array(
        'house_number' => $request->input('house_number'),
        'street_addr' => $request->input('street_addr'),
        'area' => $request->input('area'),
        'city' => $request->input('city'),
        'county' => $request->input('county'),
        'postcode' => strtoupper($request->input('postcode')),
        'country_code' => $request->input('country_code'),
        'created_at' => date('Y-m-d H:i:s')
      );
            $results = Address::InsertAddress($data);
        }
    }

    public function InsertEx($AddressInfo, $customer = 1)
    {
        if (empty($AddressInfo)) return null;
      if(!empty($customer)){
        $data = array(
          'house_number' => $AddressInfo->customer_house_number,
          'street_addr' => $AddressInfo->customer_street,
          'area' => $AddressInfo->customer_area,
          'city' => $AddressInfo->customer_town,
          'county' => $AddressInfo->customer_county,
          'postcode' => $AddressInfo->customer_postcode,
          'country_code' => $AddressInfo->customer_country,
          'created_at' => date('Y-m-d H:i:s')
        );
      }else{
        $name = (!empty($dataInfo->del_name)) ? explode(' ', $dataInfo->del_name) : '';
        $data = array(
          'house_number' => $AddressInfo->del_house_number,
          'street_addr' => $AddressInfo->del_street,
          'area' => $AddressInfo->del_area,
          'city' => $AddressInfo->del_town,
          'county' => $AddressInfo->del_county,
          'postcode' => $AddressInfo->del_postcode,
          'country_code' => $AddressInfo->del_country,
          'created_at' => date('Y-m-d H:i:s')
        );
      }
        $ID = (!empty($data)) ? Address::InsertAddress($data) : 0;
        return $ID;
    }

    private function getLocation($array = '', $fieldName = '', $Longshort = 'long_name')
    {
        if (empty($array) && empty($fieldName))  return null;
          foreach ($array as $value) {
            if($value->types[0] == $fieldName)
              return $value->$Longshort;
          }
    }
}
