<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\View;
use App\Http\Controllers\CustomersController;
use App\Http\Controllers\ColorsController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\Products;
use App\Colors;
use App\Shapes;
use App\Thickness;
use App\Holetypes;

class AdminController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $OrderController = (new OrderController);
        $this->middleware('auth');
        $OrderStats = $OrderController->OrderStats();
        View::share('OrderStats', $OrderStats);
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->userInfo = \Auth::user();
        $data['user'] = $this->userInfo;
        $data['pagetitle'] = 'Overview';
        return view('admin.welcome', $data);
    }

    public function blank()
    {
        $this->userInfo = \Auth::user();
        $data['user'] = $this->userInfo;
        $data['pagetitle'] = 'Blank Page';
        return view('admin.blank', $data);
    }
    public function invoice()
    {
        $this->userInfo = \Auth::user();
        $data['user'] = $this->userInfo;
        $data['pagetitle'] = 'Invoices';
        return view('admin.invoice', $data);
    }
    public function calendar()
    {
        $this->userInfo = \Auth::user();
        $data['user'] = $this->userInfo;
        $data['pageTitle'] = 'Calendar';
        return view('admin.calendar', $data);
    }

    public function timeline()
    {
        $this->userInfo = \Auth::user();
        $data['user'] = $this->userInfo;
        $data['pagetitle'] = 'Timeline';
        return view('admin.timeline', $data);
    }
    public function sweet()
    {
        $this->userInfo = \Auth::user();
        $data['user'] = $this->userInfo;
        $data['pagetitle'] = 'Sweet';
        return view('admin.sweet', $data);
    }

    public function gallery()
    {
        $this->userInfo = \Auth::user();
        $data['user'] = $this->userInfo;
        $data['pagetitle'] = 'Gallery';
        return view('admin.gallery', $data);
    }

    public function products()
    {
        $ProductsController = (new ProductsController);
        $mergeData = true;
        $active = true;
        $inactive = true;
        $data['user'] = \Auth::user();
        $data['colors'] = Colors::GetAll();
        $data['shapes'] = Shapes::GetAll();
        $data['categories'] = $ProductsController->GetProductCategories();
        $data['products'] = $ProductsController->GetAll($mergeData, $active, $inactive);
        $data['pagetitle'] = 'Products';
        return view('admin.products', $data);
    }

    public function productColors()
    {
        $data['user'] = \Auth::user();
        $data['colors'] = ColorsController::GetColors();
        $data['thicknesses'] = Thickness::GetAll();
        $data['pagetitle'] = 'Product Colours';
        return view('admin.product.colors', $data);
    }

    public function productThickness()
    {
        $data['user'] = \Auth::user();
        $data['thicknesses'] = Thickness::GetAll();
        $data['pagetitle'] = 'Product Thickness';
        return view('admin.product.thickness', $data);
    }

    public function productShapes()
    {
        $data['user'] = \Auth::user();
        $data['shapes'] = Shapes::GetAll();
        $data['pagetitle'] = 'Product Shapes';
        return view('admin.product.shapes', $data);
    }

    public function productCategories()
    {
        $ProductsController = (new ProductsController);
        $data['user'] = \Auth::user();
        $data['categories'] = $ProductsController->GetProductCategories();
        $data['pagetitle'] = 'Product Categories';
        return view('admin.product.categories', $data);
    }

    public function holeTypes()
    {
        $data['user'] = \Auth::user();
        $data['holetype'] = Holetypes::GetAll();
        $data['pagetitle'] = 'Hole Types';
        return view('admin.product.holetypes', $data);
    }

    public function allOrders(request $request){
      $OrderController = (new OrderController);
      $data['user'] = \Auth::user();
      $data['orders'] = $OrderController->getAllOrders($request);
      $data['pagetitle'] = 'All Orders';
      return view('admin.orders.order-list', $data);
    }

    public function order($SalesID, request $request){
      $OrderController = (new OrderController);
      $data['user'] = \Auth::user();
      $data['orderInfo'] = $OrderController->getOrdersByID($SalesID, $request);
      $data['pagetitle'] = 'Order Info - '.$SalesID;
      return view('admin.orders.order-info', $data);
    }

    public function logout()
    {
        \Auth::logout();
        return redirect('/login');
    }
}
