<?php

namespace App\Http\Controllers;
use View;

use App\Products;
use App\Colors;
use App\Checkout;
use App\CheckoutTimeline;
use App\Thickness;
use App\Files;
use App\Holetypes;
use App\PaymentResponse;
use App\Http\Controllers\ProductsController;
use App\Http\Controllers\EmailController;
use App\Http\Services\BuildService;
use App\Http\Services\WorldpayService;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;

class CheckoutController extends Controller
{

    public $ProductTotal = array();
    private $CheckoutCallback = 'https://www.justbuyplastic.co.uk/checkout/6';

    public function __construct() {
      $this->BuildService = new BuildService;
      $this->WorldpayService = new WorldpayService;
      $this->OrderController = new OrderController;
      $Encrypter = app(\Illuminate\Contracts\Encryption\Encrypter::class);
      $cookie = Cookie::get('token');
      $this->Token = (!empty($cookie)) ? $Encrypter->decrypt($cookie) : '';
      $BasketNumber = (!empty($this->Token)) ? Checkout::GetCountByCookieID($this->Token) : 0;
      $httpReferer = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : null;
      View::share ( 'GOOGLE_KEY', 'vfvbafdnvnbbfshshsh' );
      View::share ( 'URL', url() );
      View::share ( 'VERSION', date('0.hi') );
      View::share ( 'REFERER', $httpReferer );
      View::share ( 'BASKET', $BasketNumber );
    }

    public function basket(){
        $Checkout = Checkout::GetByCookieID($this->Token);
        $this->HasGotProducts($Checkout);
        $data['Checkout'] = $this->SortoutBasket($Checkout);
        $data['Totals'] = $this->CalculateTotals($Checkout);
        return view('shop.checkout.basket', $data);
    }

    public function setCookie($token){
      if(!empty($token)){
          Cookie::queue(Cookie::forever('token', $token));
          return redirect('/basket');
      }
    }

    public function RemoveChildToken($token = ''){
      if(empty($token)) return null;
      $Deleted = Checkout::DeleteByChildCookie($token);
      echo $Deleted;
    }


    public function stages(request $request, $stage = ''){
      if(!empty($stage)){
        $Token = Cookie::get('token');
        $data = array();
        $data['stage'] = $stage;
        switch($stage){
          case 1:
          $orderInfo = CheckoutTimeline::getByToken($Token);
          $data['OrderInfo'] = $orderInfo;
          $data['date'] = (!empty($orderInfo->del_date)) ? date('d-M-Y', strtotime($orderInfo->del_date)) : date('d-M-Y');
          // Request Date
          break;
          case 2:
          $orderInfo = CheckoutTimeline::getByToken($Token);
          if(empty($orderInfo)) return redirect('/basket');
            $decryptIndo = $this->decryptValues($orderInfo);
            $data['OrderInfo'] = $decryptIndo;
            $data['TitleSelect'] = $this->BuildService->BuildCheckoutTitle($decryptIndo->del_title, 'title', 'title', 'form-control white-select');
          break;
          case 3:
          $orderInfo = CheckoutTimeline::getByToken($Token);
          if(empty($orderInfo)) return redirect('/basket');
          $decryptIndo = $this->decryptValues($orderInfo);
            $data['OrderInfo'] = $decryptIndo;
            $data['TitleSelect'] = $this->BuildService->BuildCheckoutTitle($decryptIndo->customer_title, 'title', 'title', 'form-control white-select');
            $data['CountrySelect'] = $this->BuildService->BuildCheckoutCountry($decryptIndo->customer_country, 'country', 'country', 'form-control white-select');
          break;
          case 4:
          $stage4 = 1;
          $Checkout = Checkout::GetByCookieID($Token);
          $orderInfo = CheckoutTimeline::getByToken($Token);
          if(empty($orderInfo)) return redirect('/basket');
          $decryptIndo = $this->decryptValues($orderInfo, $stage4);
          $DataCheckout = $this->SortoutBasket($Checkout);
          $data['Checkout'] = $DataCheckout;
          $data['Prices'] = $this->calcTotalsStage4($DataCheckout);
          $data['OrderInfo'] = $decryptIndo;
          break;
          case 5:
          $stage5 = 1;
          $Checkout = Checkout::GetByCookieID($Token);
          $orderInfo = CheckoutTimeline::getByToken($Token);
          if(empty($orderInfo)) return redirect('/basket');
          $decryptIndo = $this->decryptValues($orderInfo, $stage5);
          $DataCheckout = $this->SortoutBasket($Checkout);
          $Prices = $this->calcTotalsStage4($DataCheckout);
          $data['WorldPay'] = $this->WorldpayService->BuildForm($decryptIndo, $Prices);
          $data['checkout'] = $DataCheckout;
          $data['callback'] = "{$this->CheckoutCallback}?t=$Token";
          $data['token'] = $Token;
          $data['stage'] = $stage;
          break;
          case 6:
          if(!empty($request->t)){
            $Checkout = Checkout::GetByCookieID($request->t);
            $orderInfo = CheckoutTimeline::getByToken($request->t);
            $PaymentResponse = PaymentResponse::getByToken($request->t);
            $decryptIndo = $this->decryptValues($orderInfo, 1);
            $data['OrderInfo'] = $decryptIndo;
            $data['PaymentResponse'] = $PaymentResponse;
          }
          dd($data);
          break;
        }
        $view = 'shop.checkout.stage'.$stage;
        return view($view, $data);
      }
    }

    public function postStages($stage = '', request $request){
      if(!empty($stage)){
        $data = array();
        switch($stage){
          case 1:
          $data['del_date'] = $this->convertDate($request->del_date);
          $data['token'] = Cookie::get('token');
          $Inserted = CheckoutTimeline::InsertorUpdate($data);
          if(!empty($Inserted)){
            return redirect('/checkout/2');
          }
          if(!empty($request->del_date) && !empty($data['token'])){
            return redirect('/checkout/2');
          }
          // Request Date
          break;
          case 2:
          $Token = Cookie::get('token');
          $data = array(
              'del_title' => Crypt::encryptString($request->title),
              'del_name' => Crypt::encryptString($request->name),
              'del_house_number' => Crypt::encryptString($request->house_number),
              'del_street' => Crypt::encryptString($request->addr1),
              'del_area' => Crypt::encryptString($request->addr2),
              'del_town' => Crypt::encryptString($request->city),
              'del_county' => Crypt::encryptString($request->county),
              'del_country' => Crypt::encryptString($request->del_country),
              'del_postcode' => Crypt::encryptString($request->postcode),
              'del_telephone' => Crypt::encryptString($request->phone)
            );
            $Updated = CheckoutTimeline::UpdatebyToken($Token, $data);
            if(!empty($Updated)){
              return redirect('/checkout/3');
            }
          break;
          case 3:
          $Token = Cookie::get('token');
          $data = array(
              'customer_title' => Crypt::encryptString($request->title),
              'customer_firstname' => Crypt::encryptString($request->firstname),
              'customer_lastname' => Crypt::encryptString($request->lastname),
              'customer_email' => Crypt::encryptString($request->email),
              'customer_house_number' => Crypt::encryptString($request->house_number),
              'customer_street' => Crypt::encryptString($request->addr1),
              'customer_area' => Crypt::encryptString($request->addr2),
              'customer_town' => Crypt::encryptString($request->city),
              'customer_county' => Crypt::encryptString($request->county),
              'customer_country' => Crypt::encryptString($request->country),
              'customer_postcode' => Crypt::encryptString($request->postcode),
              'customer_telephone' => Crypt::encryptString($request->phone)
            );
            $Updated = CheckoutTimeline::UpdatebyToken($Token, $data);
            if(!empty($Updated)){
              return redirect('/checkout/4');
            }
          break;
          case 4:
          return redirect('/checkout/5');
          break;
          case 5:
          // Payment Callback
          break;
          case 6:
          if(!empty($request->t)){
            $jsonRepsonse = json_encode($request->all());
            $Checkout = Checkout::GetByCookieID($request->t);
            $orderInfo = CheckoutTimeline::getByToken($request->t);
            $decryptIndo = $this->decryptValues($orderInfo, 1);
            $DataCheckout = $this->SortoutBasket($Checkout);
            $dataInfo['token'] = $request->t;
            $dataInfo['success'] = ($request->transStatus == 'Y') ? 1: 0;
            $dataInfo['response'] = Crypt::encryptString($jsonRepsonse);
            PaymentResponse::insert($dataInfo);
            $dataInfo['orderInfo'] = $orderInfo;
            $dataInfo['decryptIndo'] = $decryptIndo;
            $dataInfo['Checkout'] = $DataCheckout;
            $dataInfo['Prices'] = $this->calcTotalsStage4($DataCheckout);
            $SalesID = $this->OrderController->InsertOrder($dataInfo);
            mail('info@justbuyplastic.co.uk', 'You have a new order '.$SalesID, 'Hi fazzo you have a new order please login to the admin panel');
          }
          break;
        }
        $data['stage'] = $stage;
        $view = 'shop.checkout.stage'.$stage;
        return view($view, $data);
      }
    }


    public function addtoBasket(request $request){
      if(empty($request->basket)) return false;
        $token = str_random(32);
        $data['basket'] = $request->basket;
        $data['token'] = (!empty($request->t)) ? $request->t : $token;
        $Cookie = $request->cookie;
        $data['childToken'] = $token;
        $result = Checkout::Insert($data);
        if(!empty($result)){
          echo $data['token'];
        }
    }

    // --- Private Functions Only --- //

    private function convertDate($date){
      return date('Y-m-d', strtotime($date));
    }

    private function HasGotProducts($Checkout){
      if(empty($Checkout[0]->id)){
        CheckoutTimeline::DeleteByToken($this->Token);
        Checkout::DeleteByToken($this->Token);
        Cookie::queue(Cookie::forget('token'));
      }
    }

    private function SortoutBasket($Checkout){
      if(empty($Checkout)) return false;
      $ProductTotalar = array();
        foreach($Checkout as &$sale){
          $sale->basket = json_decode($sale->basket);
          $ProductID = $this->getBasketValue($sale->basket, 'choosep');
          $Color = $this->getBasketValue($sale->basket, 'choosec');
          $Thickness = $this->getBasketValue($sale->basket, 'chooset');
          $sale->Quantity = $this->getBasketValue($sale->basket, 'quantity');
          $sale->Width = $this->getBasketValue($sale->basket, 'chooseWidth');
          $sale->Length = $this->getBasketValue($sale->basket, 'chooseLength');
          $sale->Dimension = $this->getBasketValue($sale->basket, 'size');
          $sale->Price = $this->getBasketValue($sale->basket, 'price');
          $sale->Product = Products::GetbyID($ProductID);
          $sale->Color = Colors::GetByID($Color);
          $sale->Thickness = Thickness::GetByID($Thickness);
          $sale->Images = Files::GetFilebyProductID($ProductID);
          $sale->specialRequests = $this->BuildSpecialRequests($sale->basket);
          $this->ProductTotal[] = $sale->Price;
        }

        return $Checkout;
    }

    private function BuildSpecialRequests($basket = null){
       if(empty($basket)) return false;
       $array = [];
       $NumberOfHoles = $this->getBasketValue($basket, 'noHoles');
       $HoleTypeCode = $this->getBasketValue($basket, 'holetype');
       $cutout = $this->getBasketValue($basket, 'cutout');
       $screws = $this->getBasketValue($basket, 'screws');
       $screwcovers = $this->getBasketValue($basket, 'screwcovers');
       $rounded = $this->getBasketValue($basket, 'rounded');
       $Holetype = Holetypes::GetbyID($HoleTypeCode);
       if(!empty($Holetype) && !empty($NumberOfHoles)) $array[] = "$NumberOfHoles X $Holetype->name";
       if(!empty($cutout)) $array[] = "$cutout Custouts";
       if(!empty($screws)) $array[] = "$screws Screws";
       if(!empty($screwcovers)) $array[] = "$screwcovers Screw Covers";
       if(!empty($rounded)) $array[] = "$rounded Rounded Corners";
       $str = (!empty($array)) ? implode(', ', $array) :' -- No Special Requests -- ';
        return $str;
    }

    private function calcTotalsStage4($ProductsArray = null){
      if(empty($ProductsArray)) return null;
      $ItemPriceAr = array();
      $result = (object) array();
      foreach($ProductsArray as $Item):
        $ItemPriceAr[] = $Item->Price;
      endforeach;
      $TempTotal = (!empty($ItemPriceAr)) ? array_sum($ItemPriceAr) : 0;
      $result->ProductTotal = (!empty($TempTotal)) ? $this->BuildService->uknumberFormat($TempTotal / 1.2) : 0;
      $Delivery = $this->CalcDeliveryPrice($ProductsArray);
      $result->Delivery = (!empty($Delivery)) ? $this->BuildService->uknumberFormat($Delivery) : $this->BuildService->uknumberFormat(0);
      $subTotal = (!empty($result->ProductTotal)) ? $this->BuildService->uknumberFormat($result->ProductTotal + $result->Delivery) : 0;
      $result->Vat = (!empty($subTotal)) ? $this->BuildService->uknumberFormat($subTotal * 0.2) : 0;
      $result->Total = (!empty($subTotal)) ? $this->BuildService->uknumberFormat($result->Vat + $subTotal) : 0;
      return $result;
    }

    private function CalculateTotals($ProductsArray = null){
        $result = (object) array();
        $TempTotal = (!empty($this->ProductTotal)) ? array_sum($this->ProductTotal) : 0;
        $result->ProductTotal = (!empty($TempTotal)) ? $this->BuildService->uknumberFormat($TempTotal / 1.2) : 0;
        $Delivery = $this->CalcDeliveryPrice($ProductsArray);
        $result->Delivery = (!empty($Delivery)) ? $this->BuildService->uknumberFormat($Delivery) : $this->BuildService->uknumberFormat(0);
        $subTotal = (!empty($result->ProductTotal)) ? $this->BuildService->uknumberFormat($result->ProductTotal + $result->Delivery) : 0;
        $result->Vat = (!empty($subTotal)) ? $this->BuildService->uknumberFormat($subTotal * 0.2) : 0;
        $result->Total = (!empty($subTotal)) ? $this->BuildService->uknumberFormat($result->Vat + $subTotal) : 0;
        return $result;
    }

    private function getBasketValue($basket = null, $Name = ''){
      if(empty($basket)) return false;
        foreach($basket as $val){
          if(isset($val->value) && ($val->name == $Name)){
            return $val->value;
          }
        }
        return false;
    }

    private function CalcDeliveryPrice($ProductsArray = null){
      if(empty($ProductsArray)) return 0;
      $Del = 3.99;
      $delarray = array();
      foreach($ProductsArray as $Product){
         $delarray[] = $this->DeliveryPrice($Product);
      }
      if(!empty($delarray)) $Del = array_sum($delarray);
      $Del = 7.5;
      return $Del;
    }

    private function DeliveryPrice($Product = null){
        $del = 7.5;
      if(empty($Product)) return 0;
      if($Product->Width >=750 || $Product->Length >=750 ) $del = 10;
      if($Product->Width >=900 || $Product->Length >=900 ) $del = 13;
      if($Product->Width >=1000 || $Product->Length >=1000 ) $del = 24;
      if( $Product->Quantity > 1) {
        $del = ($Product->Quantity - 0.5) * $del;
      }
      return $del;
    }

    private function mergetoStr($array = null, $Delimiter = ' '){
      if(empty($array)) return '';
      $Filerted = array_filter($array);
      return implode($Delimiter, $Filerted);
    }

    private function decryptValues($array = null, $stage4 = 0){
      if(empty($array)) return false;
      $arrayCheck = array('id', 'del_date', 'token', 'time');
      $newArray = (object) array();
        foreach($array as $key => $val){
         $newArray->$key = (!empty($val) && (!in_array($key, $arrayCheck))) ? Crypt::decryptString($val) : $val;
        }
        if(!empty($stage4)){
          $newArray->customer_addr1 = $this->mergetoStr(array($newArray->customer_house_number, $newArray->customer_street));
          $newArray->del_addr1 = $this->mergetoStr(array($newArray->del_house_number, $newArray->del_street));
          $newArray->del_fullname = $this->mergetoStr(array($newArray->del_title, $newArray->del_name));
          $newArray->customer_fullname = $this->mergetoStr(array($newArray->customer_title, $newArray->customer_firstname, $newArray->customer_lastname));
        }
        return $newArray;
    }

}
