<?php

namespace App\Http\Controllers;

use App\Colors;
use App\ProductColors;
use App\Thickness;
use Illuminate\Http\Request;

class ColorsController extends Controller
{

    public static function Delete($id){
        if (!empty($id)) {
          $data = array(
            'active' => 0,
            'updated_at' => date('Y-m-d H:i:s')
          );
          $results = Colors::DeleteColor($id, $data);
          if(!empty($results)){
            $ProductColors = ProductColors::DeleteBycolorID($id);
          }
          return $results;
        }
    }

    public static function SortThickness($ValThickness = null, $thicknessArray = null){
      $result = '';
      if(!empty($ValThickness) && !empty($thicknessArray)){
        $array = explode(',', $ValThickness);
        foreach($array as &$val){
          $val = (!empty($thicknessArray[trim($val)])) ? $thicknessArray[trim($val)]->name : '';
        }
        $result = (!empty($array)) ? implode(', ', $array) : '';
      }
      return $result;
    }

    public static function GetColors(){
          $results = Colors::GetAll(true);
          if(!empty($results)){
            $Thickness = Thickness::GetAll(true);
            foreach($results as &$val){
              $val->thickness_codes = ColorsController::SortThickness($val->thickness_codes, $Thickness);
            }
          }
          return $results;
    }
}
