<?php

namespace App\Http\Controllers;

use App\Holetypes;
use Illuminate\Http\Request;

class HoletypeController extends Controller
{

  public static function GetAll(){
        $results['holetype']  = Holetypes::GetAll();
      return $results;
  }

    public static function DeleteHT($id){
       $results = 0;
        if (!empty($id)) {
          $results = Holetypes::DeleteByID($id);
        }
        return $results;
    }

    public static function UpdateHT(request $request){
       $results = 0;
       $id = $request->id;
        if (!empty($id)) {
          $data = array(
            'name' => $request->name,
            'price' => $request->price
          );
          $Updated = Holetypes::UpdateHT($id, $data);
          if(!empty($Updated)){
            return redirect()->back()->with('message','Operation Successful !');
          }else{
            return redirect()->back()->with('message','Error Updating!');
          }
        }
        return $results;
    }


    public static function GetByID($id){
        if (!empty($id)) {
          $info = Holetypes::GetByID($id);
          if(!empty($info)){
            $array['shape'] = $info;
          }
          echo json_encode($array);
        }
    }

    public static function getByArray($str){
        if (!empty($str)) {
          $explode = explode(',', $str);
          $info = Holetypes::GetByArray($explode);
          if(!empty($info)){
            $newArray = null;
            foreach($info as $val){
              $val->number_only = filter_var($val->name, FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION);
              $newArray[$val->number_only] = $val;
            }
          }
          ksort($newArray);
          echo json_encode($newArray);
        }
    }

}
