<?php

namespace App\Http\Controllers;
use View;

use App\Products;
use App\Colors;
use App\Checkout;
use App\Http\Controllers\ProductsController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cookie;

class HomeController extends Controller
{
  Private $Token;

    public function __construct() {
      $Encrypter = app(\Illuminate\Contracts\Encryption\Encrypter::class);
      $cookie = Cookie::get('token');
      $this->Token = (!empty($cookie)) ? $Encrypter->decrypt($cookie) : '';
      $BasketNumber = (!empty($this->Token)) ? Checkout::GetCountByCookieID($this->Token) : 0;
      View::share ( 'GOOGLE_KEY', 'vfvbafdnvnbbfshshsh' );
      View::share ( 'URL', url() );
      View::share ( 'VERSION', date('0.hi') );
      View::share ( 'BASKET', $BasketNumber);
    }

    public function index(){
        $data = array();
        $data['Products'] = ProductsController::GetAllwithCategoryKey(true, 1);
        return view('shop.pages.home', $data);
    }

    public function pages($pageName = ''){
      if(!empty($pageName)){
        $data = array();
        if (view()->exists('shop.pages.'.$pageName)){
          $data['Products'] = ProductsController::GetAllwithCategoryKey(true, 1);
          $view = 'shop.pages.'.$pageName;
          return view($view, $data);
        }else{
          return abort(404);
        }
      }
    }

    public function category($id = ''){
      $data = array();
      if(!empty($id)){
        $data = ProductsController::GetProductsbyCategoryID($id,1);
        return view('shop.category', $data);
      }else{
        return abort(404);
      }
    }

    private function formData($request){
      $array = (object)[];
      $newArray = null;
      $str = base64_decode($request->q);
      $tempArray = explode('&',$str);
      if(!empty($tempArray)){
        foreach($tempArray as $val){
          $valArr = explode('=',$val);
          $newArray[$valArr[0]] = $valArr[1];
        }
      }
      if($newArray['c']){$array->color = $newArray['c'];}
      if($newArray['t']){$array->thickness = $newArray['t'];}
      if($newArray['tv']){$array->thicknessVal = $newArray['tv'];}
      if($newArray['w']){$array->width = $newArray['w'];}
      if($newArray['l']){$array->length = $newArray['l'];}
      if($newArray['u']){$array->unit = $newArray['u'];}
      $array->productID = $request->id;
      return $array;
    }

    public function product(Request $request, $id){
      $data = array();
        if(!empty($id)){
          $data = ProductsController::GetProductsbyID($id,1);
          if(!empty($request->q)){
            $data['formData'] = $this->formData($request);
          }
          if(empty($data['Product'])){
            return abort(404);
          }
          $data['cookie'] = (!empty(Cookie::get('token'))) ? Cookie::get('token') : '';
          return view('shop.product', $data);
        }else{
          return abort(404);
        }
    }


    public function allproduct(){
      $data = array();
      $data['Products'] = ProductsController::GetAllwithCategoryKey(true, 1);
      $data['bestSellers'] = ProductsController::GetRandomProducts(18);
      return view('shop.products', $data);
    }

    public function testEmail(){
      $data = array();
        return view('shop.test-email', $data);
    }

    public function uses(){
      $data = array();
        return view('shop.uses', $data);
    }
}
