<?php

namespace App\Http\Controllers;

use App\Shapes;
use App\Files;
use App\Products;
use Illuminate\Http\Request;

class ShapeController extends Controller
{

    public static function DeleteShape($id){
       $Products = 0;
        if (!empty($id)) {
          $results = Shapes::DeleteByID($id);
          if(!empty($results)){
            $Products = Products::RemoveShapes($id, $results);
          }
        }
        return $Products;
    }

    public static function GetByID($id){
        if (!empty($id)) {
          $info = Shapes::GetByID($id);
          if(!empty($info)){
            $array['shape'] = $info;
            $array['files'] = Files::GetFilebyShapeID($id);
          }
          echo json_encode($array);
        }
    }

    public static function getByArray($str){
        if (!empty($str)) {
          $explode = explode(',', $str);
          $info = Shapes::GetByArray($explode);
          if(!empty($info)){
            $newArray = null;
            foreach($info as $val){
              $val->number_only = filter_var($val->name, FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION);
              $newArray[$val->number_only] = $val;
            }
          }
          ksort($newArray);
          echo json_encode($newArray);
        }
    }

}
