<?php

namespace App\Http\Controllers;

use App\Colors;
use App\ProductColors;
use App\Thickness;
use Illuminate\Http\Request;

class ThicknessController extends Controller
{

    public static function DeleteThickness(request $request){
        if (!empty($request->id)) {
          $results = Thickness::DeleteThickness($request->id);
          if(!empty($results)){
            $Colors = Colors::RemoveThickness($request->id);
            return $Colors;
          }
        }
    }

    public static function getByID($id){
        if (!empty($id)) {
          $info = Thickness::GetByID($id);
          if(!empty($info)){
              $info->number_only = filter_var($info->name, FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION);
          }
          echo json_encode($info);
        }
    }

    public static function getByArray($str){
        if (!empty($str)) {
          $explode = explode(',', $str);
          $info = Thickness::GetByArray($explode);
          if(!empty($info)){
            $newArray = null;
            foreach($info as $val){
              $val->number_only = filter_var($val->name, FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION);
              $newArray[$val->number_only] = $val;
            }
          }
          ksort($newArray);
          echo json_encode($newArray);
        }
    }

}
