<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSalesLinesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('SalesLines', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8';
            $table->collation = 'utf8_unicode_ci';
            $table->increments('SalesLineID');
            $table->tinyInteger('salesID');
            $table->tinyInteger('productID');
            $table->tinyInteger('shapeID')->default(0);
            $table->tinyInteger('colorID');
            $table->tinyInteger('thicknessID');
            $table->decimal('width', 5, 2);
            $table->decimal('length', 5, 2);
            $table->decimal('product_price', 5, 2);
            $table->dateTime('dateAmended');
            $table->text('notes');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('SalesLines');
    }
}
