(function ($) {
	$.fn.extend({
		'_data': $.fn.data,
		'data': function (key, value) {
			if (typeof key === "undefined" && this.length) {
				return jQuery.data(this[0]);
			} else if (typeof key === "object") {
				return this.each(function () {
					jQuery.data(this, key);
				});
			}
			var retValue;
			retValue = $.fn._data(key, value);
			if ('undefined' == (typeof retValue) || retValue.length == 0) {
				var nakedElem = this.get(0);
				if (is = nakedElem && nakedElem.hasOwnProperty('dataset')) {
					if ('undefined' != (typeof nakedElem.dataset[key])) {
						retValue = nakedElem.dataset[key];
					}
				} else {
					retValue = this.attr('data-' + key);
				}
			}
			return retValue;
		}
	});
})(jQuery);


$(document).ready(function () {

	$(function () {
	 addr1Change();
	});

  $('#ddcountryname').change( function(){
      addr1Change();
  });

	if ($('#city').val()) {
		removeUKhidden();
	}

	$('#enterOwn').click(function () {
		closeAlldown();
	});

	function removeUKhidden(){
		var country = $('#ddcountryname').children('option:selected').val();
			if(country==='UK'){
			$("#addr1dl").removeClass('hidden');
			$("#addr2dl").removeClass('hidden');
			$("#citydl").removeClass('hidden');
			$("#countydl").removeClass('hidden');
			$("#enterOwn").addClass('hidden');
			$("#findAddr").addClass('hidden');
		}
	}


	function closeAlldown() {

		$('#pccomp').val(1);
		$("#deladdrF").addClass('hidden');
		if($("#enterOwndl").length){
			$("#enterOwndl").addClass('hidden');
		}
		removeUKhidden();
	}

	function fetchAddrForPostcode(e, n, j) {
		"" === e ? j({
			code: "",
			number: "",
			addr1: "",
			addr2: "",
			city: "",
			county: ""
		}) : $.post("/api/postcode", {code: e, hn: n, sub: 0},
		function (k) {
			j(k);
		}
		);
	}

	function addr1Change() {
		 $('#findAddr').click(function (event) {
            event.preventDefault();
				var addr1, addr2, pccomp = $('#pccomp').val();
							fetchAddrForPostcode($('#postcode').val(), $('#house_number').val(), function (r) {
							e = (r) ? JSON.parse(r) : '';
							console.log(e);
							$('.form-group').addClass('hidden'),
							$("#deladdrF").addClass('hidden'),
							(e.town) ? $('#pccomp').val(1) : ($('#pccomp').val(pccomp)),
							$("#postcode").val(e.postcode),
							$("#addr1").val(e.Street),
							$("#addr2").val(e.area),
							$("#city").val(e.town),
							$("#county").val(e.county),
							$('.form-group').removeClass('hidden'),
							$("#deladdrF").addClass('hidden');
							$('#enterOwn').addClass('hidden');
				});
		});
	}

});
