@extends('layouts.admin')

@section('css')
<link href="/assets/plugins/footable/css/footable.core.css" rel="stylesheet">
<link href="/assets/plugins/bootstrap-select/bootstrap-select.min.css" rel="stylesheet" />
<link rel="stylesheet" href="/assets/plugins/dropify/dist/css/dropify.min.css">
<link href="/assets/plugins/sweetalert/sweetalert.css" rel="stylesheet" type="text/css">
@endsection

@section('js')
<!-- Footable -->
<script src="/assets/plugins/footable/js/footable.all.min.js"></script>
<script src="/assets/plugins/bootstrap-select/bootstrap-select.min.js" type="text/javascript"></script>
<script src="/assets/plugins/sweetalert/sweetalert.min.js" type="text/javascript"></script>
<!--FooTable init-->
<script src="/assets/js/footable-init.js"></script>
<script src="/assets/plugins/dropify/dist/js/dropify.min.js"></script>
<script src="/assets/js/custom-file-input.js"></script>
<script src="/assets/js/products.js?v={{ env('GLOBALVER') }}"></script>
@endsection

@section('content')
<!-- ============================================================== -->
<!-- Start Page Content -->
<!-- ============================================================== -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">List of current Products</h4>
                <div class="row m-t-40">
                    <!-- Column -->
                    <div class="col-md-6 col-lg-6 col-xlg-6">
                        <div class="card card-inverse card-success card-active">
                            <div class="box bg-info text-center">
                                <h1 class="font-light text-white">{{ count($products['active']) }}</h1>
                                <h6 class="text-white">Current Active Products</h6>
                            </div>
                        </div>
                    </div>
                    <!-- Column -->
                    <div class="col-md-6 col-lg-6 col-xlg-6">
                        <div class="card card-primary card-inverse card-inactive">
                            <div class="box text-center">
                                <h1 class="font-light text-white">{{ count($products['inactive']) }}</h1>
                                <h6 class="text-white">Current In-Active Products</h6>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="table-responsive">
                  <div class="active-products">
                    <table id="demo-foo-addrow" class="table m-t-30 table-hover no-wrap contact-list" data-page-size="10">
                        <thead>
                            <tr>
                                <th>ID #</th>
                                <th>Name</th>
                                <th>Category</th>
                                <th>PP KG</th>
                                <th>Gravity</th>
                                <th>Max Width</th>
                                <th>Max Height</th>
                                <th>Order</th>
                                <th>Created</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                          @foreach ($products['active'] as $product)
                            <tr>
                                <td>{{ $product->id }}</td>
                                <td>{{ $product->name }}</td>
                                <td>{{ $product->category }}</td>
                                <td>{{ $product->price_kg }}</td>
                                <td>{{ $product->gravity }}</td>
                                <td>{{ $product->max_width }}</td>
                                <td>{{ $product->max_length }}</td>
                                <td>{{ $product->pageOrder }}</td>
                                <td>{{ $product->created_at }}</td>
                                <td>
                                  <button type="button" class="btn btn-sm btn-icon btn-pure btn-outline edit-product" data-id="{{ $product->id }}" ><i class="ti-pencil-alt" aria-hidden="true"></i></button>
                                    <button type="button" class="btn btn-sm btn-icon btn-pure btn-outline btn-del-product" data-id="{{ $product->id }}"><i  class="ti-close" aria-hidden="true"></i></button>
                                </td>
                            </tr>
                            @endforeach;
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="2">
                                    <button type="button" class="btn btn-info btn-rounded" data-toggle="modal" data-target="#add-product">Add New Product</button>
                                </td>
                                <td colspan="7">
                                    <div class="text-right">
                                        <ul class="pagination"> </ul>
                                    </div>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                  </div>
                  <div class="inactive-products hidden">
                    <table id="demo-inactive-products" class="table m-t-30 table-hover no-wrap contact-list" data-page-size="10">
                        <thead>
                            <tr>
                                <th>ID #</th>
                                <th>Name</th>
                                <th>Category</th>
                                <th>PP KG</th>
                                <th>Gravity</th>
                                <th>Max Width</th>
                                <th>Max Height</th>
                                <th>Order</th>
                                <th>Created</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                          @foreach ($products['inactive'] as $inproduct)
                            <tr>
                                <td>{{ $inproduct->id }}</td>
                                <td>{{ $inproduct->name }}</td>
                                <td>{{ $inproduct->category }}</td>
                                <td>{{ $inproduct->price_kg }}</td>
                                <td>{{ $inproduct->gravity }}</td>
                                <td>{{ $inproduct->max_width }}</td>
                                <td>{{ $inproduct->max_length }}</td>
                                <td>{{ $inproduct->pageOrder }}</td>
                                <td>{{ $inproduct->created_at }}</td>
                                <td>
                                    <button type="button" class="btn btn-sm btn-icon btn-pure btn-outline reinstate-product" data-id="{{ $inproduct->id }}"><i  class="ti-back-left" aria-hidden="true"></i></button>
                                </td>
                            </tr>
                            @endforeach;
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="2">
                                </td>
                                <td colspan="7">
                                    <div class="text-right">
                                        <ul class="pagination"> </ul>
                                    </div>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                  </div>
                    <div id="add-product" class="modal fade in" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-wide">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" id="myModalLabel">Add New Product</h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                </div>
                                <div class="modal-body">
                                    <form id="new-product" method="post" enctype="multipart/form-data" class="form-horizontal form-material">
                                      {{ csrf_field() }}
                                      <input id="api_token" type="hidden" name="api_token" value="{{ $user->api_token }}">
                                      <div class="row">
                                        <div class="col-md-6 remove-overflow">
                                        <div class="form-group">
                                            <div class="col-md-12 m-b-20">
                                                <input type="text" class="form-control" name="name" placeholder="Product Name"> </div>
                                                <div class="col-md-12 m-b-20" >
                                                    <select class="selectpicker" name="catergory" data-style="form-control btn-secondary">
                                                      @foreach ($categories as $catergory)
                                                      <option value="{{ $catergory->id }}">{{ $catergory->name }}</option>
                                                      @endforeach
                                                    </select>
                                                </div>
                                            <div class="col-md-12 m-b-20" >
                                                <select class="selectpicker" name="colors[]" multiple data-style="form-control btn-secondary">
                                                  @foreach ($colors as $color)
                                                  <option value="{{ $color->id }}">{{ $color->name }} ({{ $color->code }})</option>
                                                  @endforeach
                                                </select> </div>
                                            <div class="col-md-12 m-b-20">
                                                <input type="text" class="form-control" name="per_kg" placeholder="Price per kg"> </div>
                                            <div class="col-md-12 m-b-20">
                                                <input type="text" class="form-control" name="per_sqm" placeholder="Price per sqm"> </div>

                                            <div class="col-md-12 m-b-20">
                                                <input type="text" class="form-control" name="gravity" placeholder="Gravity"> </div>
                                            <div class="col-md-12 m-b-20">
                                                <input type="text" class="form-control" name="max_width" placeholder="Max Width"> </div>
                                                <div class="col-md-12 m-b-20">
                                                    <input type="text" class="form-control" name="max_length" placeholder="Max Length"> </div>
                                                <div class="col-md-12 m-b-20">
                                                    <input type="text" class="form-control" name="page_order" placeholder="Page Order 1 - 400"> </div>
                                                    <div class="col-md-12 m-b-20">
                                                      <textarea class="form-control" name="description" placeholder="Description" rows="10"></textarea>
                                                    </div>
                                              </div>
                                            </div>
                                            <div class="col-md-6 js">
                                            <div class="col-md-12 m-b-20">
                                              <input type="file" name="imgone" id="imgone" class="dropify"/></div>
                                            <div class="col-md-12 m-b-20">
                                                <input type="file" id="imgtwo" name="imgtwo" class="dropify"/></div>
                                            <div class="col-md-12 m-b-20">
                                                <input type="file" id="imgthree" name="imgthree" class="dropify"/></div>
                                          </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="modal-footer">
                                    <button id="insert-product" class="btn btn-info waves-effect" >Insert New Product</button>
                                    <button type="button" class="btn btn-default waves-effect" data-dismiss="modal">Cancel</button>
                                </div>
                            </div>
                            <!-- /.modal-content -->
                        </div>
                        <!-- /.modal-dialog -->
                    </div>

                    <div id="edit-product" class="modal fade in" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-wide">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" id="myModalLabel">Edit Product</h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                </div>
                                <div class="modal-body">
                                    <form id="editproduct" method="post" enctype="multipart/form-data" class="form-horizontal form-material">
                                      {{ csrf_field() }}
                                      <input id="api_token" type="hidden" name="api_token" value="{{ $user->api_token }}">
                                      <input type="hidden" name="id" value="">
                                      <input type="hidden" name="_method" value="PUT">
                                      <div class="row">
                                        <div class="col-md-6">
                                        <div class="form-group remove-overflow">
                                            <div class="col-md-12 m-b-20">
                                                <input type="text" data-toggle="tooltip" title="Product Name" class="form-control" name="name" placeholder="Product Name"> </div>
                                                <div class="col-md-12 m-b-20 sel-catergory" >
                                                    <select class="selectpicker" name="catergory" data-style="form-control btn-secondary">
                                                      @foreach ($categories as $catergory)
                                                      <option value="{{ $catergory->id }}">{{ $catergory->name }}</option>
                                                      @endforeach
                                                    </select>
                                                </div>
                                            <div class="col-md-12 m-b-20 sel-colors" >
                                                <select class="selectpicker" name="colors[]" multiple data-style="form-control btn-secondary">
                                                  @foreach ($colors as $color)
                                                  <option value="{{ $color->id }}">{{ $color->name }} ({{ $color->code }})</option>
                                                  @endforeach
                                                </select> </div>
                                                <div class="col-md-12 m-b-20 sel-shapes" >
                                                    <select class="selectpicker" name="shapes[]" multiple data-style="form-control btn-secondary">
                                                      @foreach ($shapes as $shape)
                                                      <option value="{{ $shape->id }}">{{ $shape->name }}</option>
                                                      @endforeach
                                                    </select> </div>
                                            <div class="col-md-12 m-b-20">
                                                <input type="text" data-toggle="tooltip" title="Price per kg" class="form-control" name="per_kg" placeholder="Price per kg"> </div>
                                            <div class="col-md-12 m-b-20">
                                                <input type="text" data-toggle="tooltip" title="Price per sqm" class="form-control" name="per_sqm" placeholder="Price per sqm"> </div>
                                            <div class="col-md-12 m-b-20">
                                                <input type="text" data-toggle="tooltip" title="Gravity" class="form-control" name="gravity" placeholder="Gravity"> </div>
                                            <div class="col-md-12 m-b-20">
                                                <input type="text" data-toggle="tooltip" title="Max Width" class="form-control" name="max_width" placeholder="Max Width"> </div>
                                                <div class="col-md-12 m-b-20">
                                                    <input type="text" data-toggle="tooltip" title="Max Length" class="form-control" name="max_length" placeholder="Max Length"> </div>
                                                    <div class="col-md-12 m-b-20">
                                                        <input type="text"  data-toggle="tooltip"  class="form-control" name="page_order" placeholder="Page Order 1 - 400"> </div>
                                                    <div class="col-md-12 m-b-20">
                                                      <textarea data-toggle="tooltip" title="Description" class="form-control" name="description" placeholder="Description" rows="10"></textarea>
                                                    </div>
                                              </div>
                                            </div>
                                            <div class="col-md-6 js">
                                            <div class="col-xs-6 m-b-20 col-relative">
                                              <div id="imgOnePreview" class="img-preview hidden">
                                                <div class="img-preview-inner" />
                                                <span class="delete">Remove</span></div></div>
                                              <input type="file" name="Updateimgone" id="Updateimgone" class="dropify"/></div>
                                            <div class="col-xs-6 m-b-20 col-relative">
                                              <div id="imgTwoPreview" class="img-preview hidden">
                                                <div class="img-preview-inner" />
                                                <span class="delete">Remove</span></div></div>
                                                <input type="file" id="Updateimgtwo" name="Updateimgtwo" class="dropify"/></div>
                                            <div class="col-xs-6 m-b-20 col-relative">
                                              <div id="imgThreePreview" class="img-preview hidden">
                                                <div class="img-preview-inner" />
                                                <span class="delete">Remove</span>
                                              </div></div>
                                                <input type="file" id="Updateimgthree" name="Updateimgthree" class="dropify"/></div>
                                          </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="modal-footer">
                                    <button id="update-product" class="btn btn-info waves-effect" >Update Product</button>
                                    <button type="button" class="btn btn-default waves-effect" data-dismiss="modal">Cancel</button>
                                </div>
                            </div>
                            <!-- /.modal-content -->
                        </div>
                        <!-- /.modal-dialog -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- ============================================================== -->
<!-- End PAge Content -->
<!-- ============================================================== -->
@endsection
