@extends('layouts.shop')

@section('css')

@endsection

@section('js')

@endsection

@section('content')
<div class="row">
    <div class="col-lg-7 col-pad-l-5">
      <div class="ProductCategory">
        <h2>{{ $Category->name }}</h2>
        <p>{!! nl2br(e($Category->description)) !!}</p>
      </div>
    </div>
    <div class="col-lg-5 hidden-md hidden-sm hidden-xs col-pad-l-5">
@include('includes.shop.quote');
    </div>
</div>
<section id="bestSellers">
    <div class="row">
        <div class="col-sm-6 col-pad-lr-10 hidden-xs">
            <h3>Some of our best selling {{ $Category->name }} Products</h3>
        </div>
        <div class="col-sm-6 col-pad-lr-10 hidden-xs">
            <p class="text-right crafted">Crafted &amp; cut to your specification</p>
        </div>
        <div class="col-sm-12 col-pad-lr-10 hidden-xs">
            <hr>
        </div>
    </div>
    <div class="row">
      @if(!empty($Featured))
      @foreach ($Featured as $Product)
        <div class="col-md-4 col-sm-6 col-ms-6 col-pad-lr-10">
            <div class="home-gallery" data-link="https://www.justbuyplastic.co.uk{{ $Product->link }}">
                <div class="home-gal-img">
                    <div class="order-now"><span>Order Now</span></div>
                    <img src="/{{ $Product->mainImg }}" alt="{{ $Product->name }}" />
                    <div class="hs-box hidden"></div>
                </div>
                <div class="home-gal-text">
                    <h4 class="product-title">{{ $Product->name }}</h4>
                    <p>{{ $Product->short_description }}...</p>
                    <!-- <p class="home-gal-price">from <span class="price"><span class=currsym>&pound;</span>
                            <span class=curr data-d2f-curr="27.00">27.00</span></span></p> -->
                </div>
            </div>
        </div>
        @endforeach
        @endif
    </div>
</section> <! --- End Best Sellers Section --->
@endsection
