@extends('layouts.shop')

@section('meta')
<title>{{ $Category->name }} | Just Buy Plastic | Plastic Supplier in Bolton, UK</title>
<meta name="description" content="{{ $Category->name }} | Just Buy Plastic is a five-star rated plastic supplier based in Bolton, offering you everything from acrylic sheets to polycarbonate, PVC and even nylon. Buy online today!">
@endsection

@section('ogmeta')
<meta property="og:title" content="{{ $Category->name }} | Just Buy Plastic | Plastic Supplier in Bolton, UK">
<meta property="og:description" content="{{ $Category->name }} | Just Buy Plastic is a five-star rated plastic supplier based in Bolton, offering you everything from acrylic sheets to polycarbonate, PVC and even nylon. Buy online today!">
@endsection

@section('css')

@endsection

@section('js')

@endsection

@section('content')
<div class="row">
    <div class="col-lg-7 col-pad-l-5">
      <ol class="breadcrumb">
        <li><a href="/">Home</a></li>
        <li class="active">{{ $Category->name }}</li>
      </ol>
      <div class="ProductCategory">
        <h2>{{ $Category->name }}</h2>
        <p>{!! nl2br(e($Category->description)) !!}</p>
      </div>
    </div>
    <div class="col-lg-5 hidden-md hidden-sm hidden-xs col-pad-l-5">
@include('includes.shop.quote');
    </div>
</div>
<section id="bestSellers">
    <div class="row">
        <div class="col-sm-8 col-pad-lr-10 hidden-xs">
            <h3>Some of our best selling {{ $Category->name }} Products</h3>
        </div>
        <div class="col-sm-4 col-pad-lr-10 hidden-xs">
            <p class="text-right crafted">Crafted &amp; cut to your specification</p>
        </div>
        <div class="col-sm-12 col-pad-lr-10 hidden-xs">
            <hr>
        </div>
    </div>
    <div class="row">
      @foreach ($Featured as $Product)
        <div class="col-md-4 col-sm-6 col-ms-6 col-pad-lr-10">
            <div class="home-gallery" data-link="https://www.justbuyplastic.co.uk{{ $Product->link }}">
              <div class="home-gal-img">
                <div id="imgOnePreview" class="img-preview">
                  <div class="order-now"><span>Order Now</span></div>
                    <div class="img-preview-inner" title="{{ $Product->name }}" style="background-image: url(/{{ $Product->mainImg }});"></div>
                  </div>
                  <div class="hs-box hidden"></div>
              </div>
                <div class="home-gal-text">
                    <h4 class="product-title">{{ $Product->name }}</h4>
                    <p>{{ $Product->short_description }}...</p>
                    <p class="home-gal-price">from <span class="price"><span class=currsym>&pound;</span>
                            <span class=curr data-d2f-curr="27.00">27.00</span></span></p>
                </div>
            </div>
        </div>
        @endforeach
    </div>
</section> <! --- End Best Sellers Section --->
@endsection
