@extends('layouts.shop')

@section('css')
@endsection

@section('js')
<script>
$(document).ready(function(){
  $('#wpform').submit();
})
</script>
@endsection

@section('content')
<form id="wpform" action="{{ $WorldPay->Url }}" method=POST>
<!-- This next line contains the testMode parameter - it specifies that the submission is a test submission -->
<input type="hidden" name="{{ $WorldPay->Mode }}" value="{{ $WorldPay->Value }}">
<!-- This next line contains a mandatory parameter. Put your Installation ID inside the quotes after value= -->
<!-- You will need to get the installation ID from your Worldpay account. Login to your account, click setting and under installations
you should have an option called select junior and a number, put the number between "" e.g. "123456"-->
<input type="hidden" name="instId" value="{{ $WorldPay->instId }}">
<!-- Another mandatory parameter. Put your own reference identifier for the item purchased inside the quotes after value= -->
<input type="hidden" name="cartId" value="{{ $WorldPay->cartId }}">
<!-- Another mandatory parameter. Put the total cost of the item inside the quotes -->
<input type="hidden" name="amount" value="{{ $WorldPay->amount }}">
<!-- Another mandatory parameter. Put the code for the purchase currency inside the quotes after value= -->
<input type="hidden" name="currency" value="GBP">
<!-- This creates the button. When it is selected in the browser, the form submits the purchase details to us. -->
<input type="hidden" name="noLanguageMenu">
<input type="hidden" name="address1" value="{{ $WorldPay->address1 }}">
<input type="hidden" name="address2" value="{{ $WorldPay->address2 }}">
<input type="hidden" name="town" value="{{ $WorldPay->town }}">
<input type="hidden" name="region" value="{{ $WorldPay->region }}">
<input type="hidden" name="postcode" value="{{ $WorldPay->postcode }}">
<input type="hidden" name="country" value="{{ $WorldPay->country }}">
<input type="hidden" name="tel" value="{{ $WorldPay->tel }}">
<input type="hidden" name="email" value="{{ $WorldPay->email }}">
<input type="hidden" name="name" value="{{ $WorldPay->name }}">
<input type="hidden" name="MC_callback" value="{{ $callback }}">
<input type="hidden" name="MC_token" value="{{ $token }}">
@foreach($checkout as $Product)
  <input type="hidden" name="desc" value="{{ $Product->Product->name }}">
@endforeach
<input type=submit value="Buy This">
</form>
@endsection
