

<?php $__env->startSection('css'); ?>
<link href="/assets/plugins/footable/css/footable.core.css" rel="stylesheet">
<link href="/assets/plugins/bootstrap-select/bootstrap-select.min.css" rel="stylesheet" />
<link rel="stylesheet" href="/assets/plugins/dropify/dist/css/dropify.min.css">
<link href="/assets/plugins/sweetalert/sweetalert.css" rel="stylesheet" type="text/css">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<!-- Footable -->
<script src="/assets/plugins/footable/js/footable.all.min.js"></script>
<script src="/assets/plugins/bootstrap-select/bootstrap-select.min.js" type="text/javascript"></script>
<script src="/assets/plugins/sweetalert/sweetalert.min.js" type="text/javascript"></script>
<!--FooTable init-->
<script src="/assets/js/footable-init.js"></script>
<script src="/assets/plugins/dropify/dist/js/dropify.min.js"></script>
<script src="/assets/js/custom-file-input.js"></script>
<script src="/assets/js/orders.js?v=<?php echo e(env('GLOBALVER')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumbs'); ?>
<li class="breadcrumb-item"><a href="/admin/orders">All Orders</a></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
<div class="col-lg-4 col-xlg-3 col-md-5">
                        <div class="card">
                            <div class="card-body">
                              <h3><b>Order Info</b></h3>
                              <hr>
                              <small class="text-muted p-t-30 db">Name</small>
                              <h6><?php echo e($orderInfo->CustomerData->FullName); ?></h6>
                              <small class="text-muted">Email address </small>
                                <h6><?php echo e($orderInfo->CustomerData->email); ?></h6> <small class="text-muted p-t-30 db">Phone</small>
                                <h6>+<?php echo e($orderInfo->CustomerData->telephone); ?></h6>
                                <h3><b>Delivery Info</b></h3>
                                <hr>
                                <small class="text-muted p-t-30 db">Name</small>
                                <h6><?php echo e($orderInfo->DeliveryData->FullName); ?></h6>
                                <small class="text-muted p-t-30 db">Address</small>
                                  <h6><?php echo e($orderInfo->DeliveryAddress->strAddr); ?> <?php echo e($orderInfo->DeliveryAddress->city); ?>, <?php echo e($orderInfo->DeliveryAddress->postcode); ?></h6>
                                <div class="map-box">
                                    <iframe src="https://maps.google.com/maps?&q=<?php echo e(urlencode($orderInfo->DeliveryAddress->strAddr)); ?>,<?php echo e(urlencode($orderInfo->DeliveryAddress->city)); ?>,<?php echo e(urlencode($orderInfo->DeliveryAddress->postcode)); ?>,gb&output=embed" width="100%" height="150" frameborder="0" style="border:0" allowfullscreen=""></iframe>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-8 col-xlg-9 col-md-7">
<div class="row">
                    <div class="col-md-12">
                        <div class="card card-body printableArea">
                            <h3><b>INVOICE</b> <span class="pull-right">#<?php echo e($orderInfo->Invoice); ?></span></h3>
                            <hr>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="pull-left">
                                        <address>
                                            <h3> &nbsp;<b class="text-danger">Justbuyplastic.co.uk</b></h3>
                                            <p class="text-muted m-l-5">9 Peaks Place,
                                                <br> Rossini Street,
                                                <br> Bolton,
                                                <br> BL1 8GJ</p>
                                        </address>
                                    </div>
                                    <div class="pull-right text-right">
                                        <address>
                                            <h3>To,</h3>
                                            <h4 class="font-bold"><?php echo e($orderInfo->CustomerData->FullName); ?>,</h4>
                                            <p class="text-muted m-l-30"><?php echo e($orderInfo->CustomerAddress->strAddr); ?>,
                                                <br> <?php echo e($orderInfo->CustomerAddress->city); ?>,
                                                <br> <?php echo e($orderInfo->CustomerAddress->county); ?>,
                                              <br> <?php echo e($orderInfo->CustomerAddress->postcode); ?></p>
                                            <p class="m-t-30"><b>Order Date :</b> <i class="fa fa-calendar"></i> <?php echo e(date('jS F, Y', strtotime($orderInfo->orderDate))); ?></p>
                                        </address>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="table-responsive m-t-40" style="clear: both;">
                                        <table class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th class="text-center">#</th>
                                                    <th>Description</th>
                                                    <th>Color</th>
                                                    <th>Thickness</th>
                                                    <th>Size</th>
                                                    <th>note</th>
                                                    <th class="text-right">Quantity</th>
                                                    <th class="text-right">Unit Inc Vat</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                              <?php if(!empty($orderInfo->orderLines)): ?>
                                              <?php $__currentLoopData = $orderInfo->orderLines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $Lines): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td class="text-center"><?php echo e($key+1); ?></td>
                                                    <td><?php echo e($Lines->ProductInfo->name); ?></td>
                                                    <td><?php echo e($Lines->colorInfo->name); ?></td>
                                                    <td><?php echo e($Lines->thicknessInfo->name); ?></td>
                                                    <td>W:<?php echo e($Lines->width); ?><?php echo e($Lines->dimension); ?> x L:<?php echo e($Lines->length); ?><?php echo e($Lines->dimension); ?></td>
                                                    <td><?php echo e($Lines->notes); ?></td>
                                                    <td class="text-right"><?php echo e($Lines->quantity); ?></td>
                                                    <td class="text-right">&pound;<?php echo e($Lines->product_price); ?></td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>
                                     </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="pull-right m-t-30 text-right">
                                        <p>Sub - Total amount: &pound;<?php echo e($orderInfo->total); ?></p>
                                        <p>vat (20%) : &pound;<?php echo e($orderInfo->vat); ?></p>
                                        <p>Delivery : &pound;<?php echo e($orderInfo->delivery); ?></p>
                                        <hr>
                                        <h3><b>Total :</b> &pound;<?php echo e($orderInfo->totalincDel); ?></h3>
                                    </div>
                                    <div class="clearfix"></div>
                                    <hr>
                                    <div class="row">
                                      <div class="col-md-6">
                                      <select class="form-control" id="order-status" data-id="<?php echo e($orderInfo->salesID); ?>"  data-status="<?php echo e($orderInfo->status); ?>">
                                        <option <?php if($orderInfo->status == "Ordered"): ?>selected <?php endif; ?> value="Ordered">Ordered</option>
                                        <option <?php if($orderInfo->status == "Processing"): ?>selected <?php endif; ?> value="Processing">Processing</option>
                                        <option <?php if($orderInfo->status == "Dispatched"): ?>selected <?php endif; ?> value="Dispatched">Dispatched</option>
                                        <option <?php if($orderInfo->status == "Delivered"): ?>selected <?php endif; ?> value="Delivered">Delivered</option>
                                        <option <?php if($orderInfo->status == "Cancelled"): ?>selected <?php endif; ?> value="Cancelled">Cancelled</option>
                                      </select>
                                    </div>
                                    <div class="col-md-6">
                                    <div class="text-right">
                                        <button id="print" class="btn btn-default btn-outline" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
                                    </div>
                                  </div>
                                </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
              </div>
          </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>