

<?php $__env->startSection('css'); ?>
<link href="/assets/plugins/footable/css/footable.core.css" rel="stylesheet">
<link href="/assets/plugins/bootstrap-select/bootstrap-select.min.css" rel="stylesheet" />
<link rel="stylesheet" href="/assets/plugins/dropify/dist/css/dropify.min.css">
<link href="/assets/plugins/sweetalert/sweetalert.css" rel="stylesheet" type="text/css">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<!-- Footable -->
<script src="/assets/plugins/footable/js/footable.all.min.js"></script>
<script src="/assets/plugins/bootstrap-select/bootstrap-select.min.js" type="text/javascript"></script>
<script src="/assets/plugins/sweetalert/sweetalert.min.js" type="text/javascript"></script>
<!--FooTable init-->
<script src="/assets/js/footable-init.js"></script>
<script src="/assets/plugins/dropify/dist/js/dropify.min.js"></script>
<script src="/assets/js/custom-file-input.js"></script>
<script src="/assets/js/orders.js?v=<?php echo e(env('GLOBALVER')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- ============================================================== -->
<!-- Start Page Content -->
<!-- ============================================================== -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">List of current Products</h4>
                <div class="row m-t-40">
                    <!-- Column -->
                    <div class="col-md-4">
                        <div class="card card-inverse card-success card-active">
                            <div class="box bg-info text-center">
                                <h1 class="font-light text-white"><?php echo e(count($orders['active'])); ?></h1>
                                <h6 class="text-white">Current Orders</h6>
                            </div>
                        </div>
                    </div>
                    <!-- Column -->
                    <?php if(!empty($orders['completed'])): ?><div class="col-md-4">
                        <div class="card card-primary card-inverse card-completed">
                            <div class="box text-center">
                                <h1 class="font-light text-white"><?php echo e(count($orders['completed'])); ?></h1>
                                <h6 class="text-white">Completed Orders</h6>
                            </div>
                        </div>
                    </div><?php endif; ?>
                    <?php if(!empty($orders['cancelled'])): ?><div class="col-md-4">
                        <div class="card card-primary card-inverse card-cancelled">
                            <div class="box text-center">
                                <h1 class="font-light text-white"><?php echo e(count($orders['cancelled'])); ?></h1>
                                <h6 class="text-white">Cancelled Orders</h6>
                            </div>
                        </div>
                    </div><?php endif; ?>
                </div>
                <div class="table-responsive orders-table">
                  <div class="active-orders">
                    <table id="demo-foo-addrow" class="table m-t-30 table-hover no-wrap contact-list" data-page-size="10">
                        <thead>
                            <tr>
                                <th>ID #</th>
                                <th>Date</th>
                                <th>Required</th>
                                <th>Status</th>
                                <th>Name</th>
                                <th>Town</th>
                                <th>Postcode</th>
                                <th>Price</th>
                                <th>Vat</th>
                                <th>Delivery</th>
                                <th>Total</th>
                            </tr>
                        </thead>
                        <tbody>
                          <?php $__currentLoopData = $orders['active']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="view-order" data-link="/admin/orders/<?php echo e($order->salesID); ?>">
                                <td><?php echo e($order->salesID); ?></td>
                                <td><?php echo e(date('d-m-Y', strtotime($order->orderDate))); ?></td>
                                <td><?php echo e(date('d-m-Y', strtotime($order->delivery_date))); ?></td>
                                <td><?php echo e($order->status); ?></td>
                                <td><?php echo e($order->FullName); ?></td>
                                <td><?php echo e($order->Town); ?></td>
                                <td><?php echo e($order->Postcode); ?></td>
                                <td>&pound;<?php echo e($order->total); ?></td>
                                <td>&pound;<?php echo e($order->vat); ?></td>
                                <td>&pound;<?php echo e($order->delivery); ?></td>
                                <td>&pound;<?php echo e($order->totalincDel); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>;
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="7">
                                    <div class="text-right">
                                        <ul class="pagination"> </ul>
                                    </div>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                  </div>
                  <?php if(!empty($orders['completed'])): ?><div class="completed-orders hidden">
                    <table id="demo-completed-orders" class="table m-t-30 table-hover no-wrap contact-list" data-page-size="10">
                        <thead>
                            <tr>
                              <th>ID #</th>
                              <th>Date</th>
                              <th>Required</th>
                              <th>Status</th>
                              <th>Name</th>
                              <th>Town</th>
                              <th>Postcode</th>
                              <th>Price</th>
                              <th>Vat</th>
                              <th>Delivery</th>
                              <th>Total</th>
                            </tr>
                        </thead>
                        <tbody>
                          <?php $__currentLoopData = $orders['completed']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <tr>
                            <td class="view-order" data-link="/admin/orders/<?php echo e($order->salesID); ?>"><?php echo e($order->salesID); ?></td>
                            <td><?php echo e(date('d-m-Y', strtotime($order->orderDate))); ?></td>
                            <td><?php echo e(date('d-m-Y', strtotime($order->delivery_date))); ?></td>
                            <td><?php echo e($order->status); ?></td>
                            <td><?php echo e($order->FullName); ?></td>
                            <td><?php echo e($order->Town); ?></td>
                            <td><?php echo e($order->Postcode); ?></td>
                            <td>&pound;<?php echo e($order->total); ?></td>
                            <td>&pound;<?php echo e($order->vat); ?></td>
                            <td>&pound;<?php echo e($order->delivery); ?></td>
                            <td>&pound;<?php echo e($order->totalincDel); ?></td>
                          </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>;
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="2">
                                </td>
                                <td colspan="7">
                                    <div class="text-right">
                                        <ul class="pagination"> </ul>
                                    </div>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                  </div><?php endif; ?>
                  <?php if(!empty($orders['cancelled'])): ?><div class="cancelled-orders hidden">
                    <table id="demo-cancelled-orders" class="table m-t-30 table-hover no-wrap contact-list" data-page-size="10">
                        <thead>
                            <tr>
                              <th>ID #</th>
                              <th>Date</th>
                              <th>Required</th>
                              <th>Status</th>
                              <th>Name</th>
                              <th>Town</th>
                              <th>Postcode</th>
                              <th>Price</th>
                              <th>Vat</th>
                              <th>Delivery</th>
                              <th>Total</th>
                            </tr>
                        </thead>
                        <tbody>
                          <?php $__currentLoopData = $orders['cancelled']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <tr>
                            <td class="view-order" data-link="/admin/orders/<?php echo e($order->salesID); ?>"><?php echo e($order->salesID); ?></td>
                            <td><?php echo e(date('d-m-Y', strtotime($order->orderDate))); ?></td>
                            <td><?php echo e(date('d-m-Y', strtotime($order->delivery_date))); ?></td>
                            <td><?php echo e($order->status); ?></td>
                            <td><?php echo e($order->FullName); ?></td>
                            <td><?php echo e($order->Town); ?></td>
                            <td><?php echo e($order->Postcode); ?></td>
                            <td>&pound;<?php echo e($order->total); ?></td>
                            <td>&pound;<?php echo e($order->vat); ?></td>
                            <td>&pound;<?php echo e($order->delivery); ?></td>
                            <td>&pound;<?php echo e($order->totalincDel); ?></td>
                          </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>;
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="2">
                                </td>
                                <td colspan="7">
                                    <div class="text-right">
                                        <ul class="pagination"> </ul>
                                    </div>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                  </div><?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- ============================================================== -->
<!-- End PAge Content -->
<!-- ============================================================== -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>