<?php

namespace App;

use DB;
use App\Files;
use Illuminate\Database\Eloquent\Model;
use Intervention\Image\ImageManagerStatic as Image;
use Illuminate\Support\Facades\Storage;

class Colors extends Model
{


    public static function GetAll($ShowImages = false)
    {
        $results = DB::table('colors')->where('active', 1)->get();
        if(!empty($ShowImages)){
          $AllFiles = Files::GetAllFiles('ColorID');
          foreach($results as &$val){
            $val->imgOne = (!empty($AllFiles[$val->id][0])) ? $AllFiles[$val->id][0]->path_small : '';
            $val->imgTwo = (!empty($AllFiles[$val->id][1])) ? $AllFiles[$val->id][1]->path_small : '';
          }
        }
        return $results;
    }


    public static function GetbyName($name)
    {
        $ColorInfo = DB::table('colors')->where('name', $name)->get();
        return $ColorInfo;
    }

    public static function GetByID($id)
    {
        $ColorInfo = DB::table('colors')->where('id', $id)->first();
        return $ColorInfo;
    }

    public static function GetbyCode($code)
    {
        $ColorInfo = DB::table('colors')->where('code', $code)->get();
        return $ColorInfo;
    }

    public static function Get($ColorID)
    {
        $ColorInfo = DB::table('colors')->where('id', $ColorID)->first();
        return $ColorInfo;
    }

    public static function GetOne($data)
    {
        $ColorInfo = DB::table('colors')->where($data)->first();
        return $ColorInfo;
    }

    public static function GetAllIn($array = null, $indexKey = false)
    {
      if(empty($array)) return null;
        $fixedArray = array_filter(array_unique($array));
        $All = DB::table('colors')->whereIn('id', $fixedArray)->get();
        if(!empty($indexKey)){
          if(!empty($All)){
            $NewArray = null;
            foreach($All as $one){
              $NewArray[$one->id] = $one;
            }
            return $NewArray;
          }
        }
        return $All;
    }

    public static function DeleteColor($ID, $data)
    {
        $result = DB::table('colors')->where('id', $ID)->update($data);
        return $result;
    }

    public static function AddColorstoFiles($request = null, $val = null, $key = 0, $ColorID = 0)
    {
      if(!empty($request)  && !empty($val) && !empty($ColorID)){
        $newName = uniqid();
        $ColorFilePath = 'files/colors/';
        $fileName = str_replace(' ', '-', trim($request->name)).'.'.$key.'.jpg';
        $data = array(
          'ColorID'=> $ColorID,
          'orignal_name'=> $fileName,
          'path'=> $ColorFilePath. 'or/' .$newName.'.jpg',
          'path_medium'=>$ColorFilePath. 'md/' .$newName.'-600m.jpg',
          'path_small'=>$ColorFilePath. 'sm/' .$newName.'-200s.jpg',
        );
        $moveFile =  $newName.'.jpg';
        Files::InsertFile($data);
        $newLocation = $request->file($val)->storeAs($ColorFilePath. 'or/', $moveFile);
        $request->$val->move(public_path($ColorFilePath. 'or/'), $moveFile);
        Image::make($ColorFilePath . 'or/' . $moveFile)
        ->resize(600, null, function ($constraint){$constraint->aspectRatio();})
        ->save(public_path($data['path_medium']));
        Image::make($ColorFilePath . 'or/' . $moveFile)
        ->resize(200, null, function ($constraint){$constraint->aspectRatio();})
        ->save(public_path($data['path_small']));

      }

    }

    public static function InsertNewColor($request)
    {
        if (!empty($request->name)) {
          $thickness_codes = (!empty($request->thickness)) ? implode(',',$request->thickness):'';
            $data = array(
              'name' => $request->name,
              'code' => $request->code,
              'thickness_codes' => $thickness_codes
            );
            $GotOne = Colors::GetOne($data);
            if(empty($GotOne)){
                DB::table('colors')->insert($data);
                $ColorID = DB::getPdo()->lastInsertId();
                if ($request->isMethod('post') && !empty($ColorID)) {
                    $Img = array('imgone','imgtwo');
                    foreach ($Img as $key => $val) {
                        if ($request->hasFile($val)) {
                            if ($request->file($val)->isValid()) {
                              Colors::AddColorstoFiles($request, $val, $key,$ColorID);
                            }
                        }
                    }
                    return redirect()->back()->with('message','Operation Successful !');
                }
            }else{
              return redirect()->back()->with('message','Data Allready In !');
            }
        }
    }

    public static function UpdateColors($request)
    {
        if (!empty($request->name)) {
          $thickness_codes = (!empty($request->thickness)) ? implode(',',$request->thickness):'';
            $data = array(
              'name' => $request->name,
              'code' => $request->code,
              'thickness_codes' => $thickness_codes
            );
            $GotOne = Colors::GetOne(array('id'=>$request->id));
            if(!empty($GotOne)){
                DB::table('colors')->where('id', $request->id)->update($data);
                $ColorID = $request->id;
                if ($request->isMethod('put') && !empty($ColorID)) {
                    $Img = array('imgone','imgtwo');
                    foreach ($Img as $key => $val) {
                        if ($request->hasFile($val)) {
                            if ($request->file($val)->isValid()) {
                              Colors::AddColorstoFiles($request, $val, $key,$ColorID);
                            }
                        }
                    }
                    return redirect()->back()->with('message','Operation Successful !');
                }
            }else{
              return redirect()->back()->with('message','Data Allready In !');
            }
        }
    }

    public static function FindRebuild($Str = '', $ID = 0){
      if(!empty($Str) && !empty($ID)){
        $StrArray = explode(',', $Str);
        $newArray = array_diff($StrArray, array($ID));
        $newStr = implode(',',$newArray);
        return $newStr;
      }
    }

    public static function RemoveThickness($ID = 0){
      $results = 0;
      if(!empty($ID)){
        $IDSql = '%'.$ID.'%';
        $AllColors = DB::table('colors')->where('thickness_codes', 'like', $IDSql)->get();
        $Newresults = null;
          foreach($AllColors as $val){
            $thickness_codes = Colors::FindRebuild($val->thickness_codes, $ID);
            $Data = array('thickness_codes'=>$thickness_codes);
            $Newresults[] = DB::table('colors')->where('id', $val->id)->update($Data);
          }
          if(!empty($Newresults)){
            $results = (array_sum($Newresults) > 0) ? 1 : 0;
          }
      }
      return $results;
    }


}
