<?php

namespace App;
use DB;
use Illuminate\Database\Eloquent\Model;

class Customers extends Model
{
    //

    public static function GetByID($CustomerID)
    {
        $CustomerInfo = Customers::where('id', $CustomerID)->first();
        return $CustomerInfo;
    }

    public static function GetAllIn($array = null, $indexKey = false)
    {
      if(empty($array)) return null;
        $fixedArray = array_filter(array_unique($array));
        $AllCustomers = Customers::whereIn('id', $fixedArray)->get();
        if(!empty($indexKey)){
          if(!empty($AllCustomers)){
            $NewArray = null;
            foreach($AllCustomers as $Customer){
              $NewArray[$Customer->id] = $Customer;
            }
            return $NewArray;
          }
        }
        return $AllCustomers;
    }

    public static function InsertCustomer($data = null)
    {
        if (!empty($data)) {
            $CustomerInfo = Customers::insert($data);
            $ID = DB::getPdo()->lastInsertId();
            return $ID;
        }
    }

    public static function UpdateCustomer($CustomerID = 0, $data = null)
    {
        if (!empty($data)) {
            $Update = Customers::where('id', $CustomerID)->update($data);
            return $Update;
        }
    }
}
