<?php

namespace App\Http\Controllers;

use App\Customers;
use App\Address;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;

use App\Http\Services\ServerService;

class CustomersController extends Controller
{

  private $decript = array('business_name','title','firstname','lastname','email','telephone');

    public function InsertNewCustomer(Request $request)
    {
        if (!empty($request->input('email'))) {
            $data = array(
        'type'=>'delivery',
        'business_name' => Crypt::encryptString($request->input('business_name')),
        'title' => Crypt::encryptString($request->input('title')),
        'firstname' => Crypt::encryptString($request->input('firstname')),
        'lastname' => Crypt::encryptString($request->input('lastname')),
        'email' => Crypt::encryptString($request->input('email')),
        'telephone' => Crypt::encryptString($request->input('telephone')),
        'created_at' => date('Y-m-d H:i:s')
      );
            $results = Customers::InsertCustomer($data);
        }
    }

    public function InsertEx($dataInfo, $customer = 1)
    {
        if (empty($dataInfo)) return null;
        if(!empty($customer)){
          $data = array(
          'type'=>'delivery',
          'business_name' => '',
          'title' => (!empty($dataInfo->customer_title)) ? Crypt::encryptString($dataInfo->customer_title) : '',
          'firstname' => (!empty($dataInfo->customer_firstname)) ? Crypt::encryptString($dataInfo->customer_firstname) : '',
          'lastname' => (!empty($dataInfo->customer_lastname)) ? Crypt::encryptString($dataInfo->customer_lastname) : '',
          'email' => (!empty($dataInfo->customer_email)) ? Crypt::encryptString($dataInfo->customer_email) : '',
          'telephone' => (!empty($dataInfo->customer_telephone)) ? Crypt::encryptString($dataInfo->customer_telephone) : '',
          'created_at' => date('Y-m-d H:i:s')
          );
        }else{
          $name = (!empty($dataInfo->del_name)) ? explode(' ', $dataInfo->del_name) : '';
          $data = array(
          'type'=>'delivery',
          'business_name' => '',
          'title' => (!empty($dataInfo->del_title)) ? Crypt::encryptString($dataInfo->del_title) : '',
          'firstname' => (!empty($name[0])) ? Crypt::encryptString($name[0]) : '',
          'lastname' => (!empty($name[1])) ? Crypt::encryptString($name[1]) : '',
          'email' => '',
          'telephone' => (!empty($dataInfo->del_telephone)) ? Crypt::encryptString($dataInfo->del_telephone) : '',
          'created_at' => date('Y-m-d H:i:s')
          );
        }

            $ID = (!empty($data)) ? Customers::InsertCustomer($data) : 0;
            return $ID;
    }

    public function InsertNewNewsLetterCustomer(Request $request)
    {
        if (!empty($request->e)) {
            $data = array(
              'type'=>'newsletter',
              'business_name' => '',
              'title' => '',
              'firstname' => '',
              'lastname' => '',
              'email' => Crypt::encryptString($request->e),
              'telephone' => '',
              'created_at' => date('Y-m-d H:i:s')
            );
            $results = Customers::InsertCustomer($data);
            if(!empty($request->t)){
              $ar['success'] = (!empty($results)) ? 'Your Email Has been added to our newsletter.' : false;
              $ar['error'] = (empty($results)) ? 'Sorry...There has been an error.' : false;
              ServerService::jsonEncode($ar);
            }
            echo $results;
        }
    }

    public function GetByID($id)
    {
        if (!empty($id)) {
            $results = Customers::GetByID($id);
            foreach($this->decript as $val){
              $results->$val = Crypt::decryptString($results->$val);
            }
            print_r($results);
        }
    }
}
