<?php

namespace App\Http\Controllers;

use App\SalesHeader;
use App\SalesLines;
use App\Checkout;
use App\Address;
use App\Customers;
use App\Products;
use App\Colors;
use App\Thickness;
use App\CheckoutTimeline;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\View;

use App\Http\Controllers\CustomersController;
use App\Http\Controllers\SalesHeaderController;
use App\Http\Controllers\AddressController;

class OrderController extends Controller
{

  private $CompletedOrders = array('Delivered');
  private $CancelledOrders = array('Cancelled');
  private $ActiveOrders = array('Ordered','Processing','Dispatched');

  public function __construct() {
    $OrderStats = $this->OrderStats();
    View::share('OrderStats', $OrderStats);
  }


  public function OrderStats(){
      $firstDate = date('Y-m-01');
      $from = date('Y-m-d', strtotime('-1 Month', strtotime($firstDate)));
      $to = date('Y-m-d');
      $Orders = SalesHeader::GetRangeEx($from, $to);
      $newArray = array();
      foreach($Orders as $order):
        if($order->status !='Cancelled'){
          $month = date('Y-m-01', strtotime($order->orderDate));
          $newArray[$month][] = $order->totalincDel;
        }
      endforeach;
      $returnArray = array('orders'=>$Orders, 'monthlyStats'=>$newArray);
      return $returnArray;
  }

  public function getAllOrders($request){
    $Orders = SalesHeader::GetAll();
    if(empty($Orders)) return null;
    $CArray = $DelAddrArray = array();
    foreach($Orders as $order):
      $CArray[] = $order->customerID;
      $DelAddrArray[] = $order->deliveryAddrID;
    endforeach;
    $indexKey = true;
    $CustomerInfo = Customers::GetAllIn($CArray, $indexKey);
    $DelAddrInfo = Address::GetAllIn($DelAddrArray, $indexKey);
    $Totals = (object) array();
    $CompletedOrders = $ActiveOrders = $CancelledOrders = array();
    foreach($Orders as $order):
      if(in_array($order->status, $this->CompletedOrders)){
        $Totals->total[] = $order->total;
        $Totals->vat[] = $order->vat;
        $Totals->delivery[] = $order->delivery;
        $Totals->totalincDel[] = $order->totalincDel;
        $order = $this->AddCustomerAddressInfo($order, $CustomerInfo, $DelAddrInfo);
        $CompletedOrders[] = $order;
      }
      if(in_array($order->status, $this->ActiveOrders)){
          $Totals->total[] = $order->total;
          $Totals->vat[] = $order->vat;
          $Totals->delivery[] = $order->delivery;
          $Totals->totalincDel[] = $order->totalincDel;
          $order = $this->AddCustomerAddressInfo($order, $CustomerInfo, $DelAddrInfo);
          $ActiveOrders[] = $order;
      }
      if(in_array($order->status, $this->CancelledOrders)){
          $Totals->total[] = $order->total;
          $Totals->vat[] = $order->vat;
          $Totals->delivery[] = $order->delivery;
          $Totals->totalincDel[] = $order->totalincDel;
          $order = $this->AddCustomerAddressInfo($order, $CustomerInfo, $DelAddrInfo);
          $CancelledOrders[] = $order;
      }
    endforeach;
    $AllOrders = array('active'=>$ActiveOrders, 'completed'=>$CompletedOrders, 'cancelled'=>$CancelledOrders);
    return $AllOrders;
  }

  private function AddCustomerAddressInfo($order, $CustomerInfo, $DelAddrInfo){

    $order->FullName = $this->BuildName($CustomerInfo[$order->customerID]);
    $order->Town = '';
    $order->Postcode = '';
    if(!empty($DelAddrInfo[$order->deliveryAddrID])){
      $addrInfo = $DelAddrInfo[$order->deliveryAddrID];
      $order->Town = $addrInfo->city;
      $order->Postcode = $addrInfo->postcode;
    }
    return $order;
  }

  private function AddAllCustomerAddressInfo($order, $CustomerInfo, $DelAddrInfo){
    $order->CustomerData = $this->decryptCustomer($CustomerInfo[$order->customerID]);
    $order->CustomerAddress = $this->SortAddressInfo($DelAddrInfo[$order->customerAddrID]);
    $order->DeliveryData = $this->decryptCustomer($CustomerInfo[$order->deliveryID]);
    $order->DeliveryAddress = $this->SortAddressInfo($DelAddrInfo[$order->deliveryAddrID]);
    return $order;
  }

  private function BuildName($array = null){
    $nameArray = array();
    if(empty($array)) return '';
    if(!empty($array->title)) $nameArray[] = Crypt::decryptString($array->title);
    if(!empty($array->firstname)) $nameArray[] = Crypt::decryptString($array->firstname);
    if(!empty($array->lastname)) $nameArray[] = Crypt::decryptString($array->lastname);
    $fixedArray = array_filter(array_unique($nameArray));
    return implode(' ', $fixedArray);
  }

  private function SortAddressInfo($array = null){
    $info = (object) array();
    if(empty($array)) return null;
    $arr= array();
    if(!empty($array->house_number)) $arr[] = $array->house_number;
    if(!empty($array->street_addr)) $arr[] = $array->street_addr;
    $strAddr = (!empty($arr)) ? implode(' ', $arr) : '';
      $info = $array;
      $info->strAddr = $strAddr;
      return $info;
  }

  private function decryptCustomer($array = null){
    $info = (object) array();
    if(empty($array)) return null;
      $info->business_name = (!empty($array->business_name)) ? Crypt::decryptString($array->business_name) : '';
      $info->title = (!empty($array->title)) ? Crypt::decryptString($array->title) : '';
      $info->firstname = (!empty($array->firstname)) ? Crypt::decryptString($array->firstname) : '';
      $info->lastname = (!empty($array->lastname)) ? Crypt::decryptString($array->lastname) : '';
      $info->email = (!empty($array->email)) ? Crypt::decryptString($array->email) : '';
      $info->telephone = (!empty($array->telephone)) ? Crypt::decryptString($array->telephone) : '';
      $info->FullName = implode(' ', array_filter(array_unique(array($info->title,$info->firstname,$info->lastname))));
      return $info;
  }


  public function getOrdersByID($SalesID, $request){
    if(empty($SalesID)) return false;
    $indexKey = true;
    $orderInfo = SalesHeader::GetbysalesID($SalesID);
    $orderLines = SalesLines::GetbysalesIDEx($SalesID);
    $orderInfo->orderLines = $this->SortOrderLines($orderLines);
    $orderInfo->Invoice = str_pad($orderInfo->salesID, 7, 0, STR_PAD_LEFT);
    $CArray = $DelAddrArray = array();
    $CArray[] = $orderInfo->customerID;
    $CArray[] = $orderInfo->deliveryID;
    $DelAddrArray[] = $orderInfo->customerAddrID;
    $DelAddrArray[] = $orderInfo->deliveryAddrID;
    $CustomerInfo = Customers::GetAllIn($CArray, $indexKey);
    $DelAddrInfo = Address::GetAllIn($DelAddrArray, $indexKey);
    $orderInfo = $this->AddAllCustomerAddressInfo($orderInfo, $CustomerInfo, $DelAddrInfo);
    if(!empty($request->e)) dd($orderInfo);
    return $orderInfo;
  }

  private function SortOrderLines($orderLines = null){
    if(empty($orderLines)) return null;
    $productsArray = $colorArray = $thicknessArray = null;
      foreach($orderLines as $Line){
        if(!empty($Line->productID)) $productsArray[] = $Line->productID;
        if(!empty($Line->colorID)) $colorArray[] = $Line->colorID;
        if(!empty($Line->thicknessID)) $thicknessArray[] = $Line->thicknessID;
      }
      $indexKey = 1;
      $productsInfo = Products::GetAllIn($productsArray, $indexKey);
      $colorInfo = Colors::GetAllIn($colorArray, $indexKey);
      $thicknessInfo = Thickness::GetAllIn($thicknessArray, $indexKey);
      foreach($orderLines as &$Line){
      $Line->ProductInfo = (!empty($productsInfo[$Line->productID])) ? $productsInfo[$Line->productID] : '';
      $Line->colorInfo = (!empty($colorInfo[$Line->colorID])) ? $colorInfo[$Line->colorID] : '';
      $Line->thicknessInfo = (!empty($thicknessInfo[$Line->thicknessID])) ? $thicknessInfo[$Line->thicknessID] : '';
      }
      return $orderLines;
  }

  public function InsertOrder($dataInfo = null){
    if(empty($dataInfo)) return null;
      $CustomersController = (new CustomersController);
      $AddressController =  (new AddressController);
      $customerID = $CustomersController->InsertEx($dataInfo['decryptIndo'],1);
      $deliveryID = $CustomersController->InsertEx($dataInfo['decryptIndo'],0);
      $customerAddrID = $AddressController->InsertEx($dataInfo['decryptIndo'],1);
      $deliveryAddrID = $AddressController->InsertEx($dataInfo['decryptIndo'],0);
      $SalesID = $this->InsertSalesOrder($dataInfo, $customerID, $deliveryID,  $customerAddrID, $deliveryAddrID);
      $OrderLines = $this->InsertSalesOrderLines($dataInfo, $SalesID);
      //mail('kyleclassic@gmail.com','Post Callbacks', print_r($dataInfo,true));
      if(!empty($OrderLines)){
        $tempdata = array('complete' => 1);
        CheckoutTimeline::UpdatebyToken($dataInfo['token'], $tempdata);
        Checkout::DeleteByCookie($dataInfo['token']);
        return $SalesID;
      }
  }

  public function updateStatus($salesID, $status){
    if(empty($salesID)) return null;
    $data['status'] = $status;
    return SalesHeader::UpdatebysalesID($salesID, $data);
  }

  private function InsertSalesOrder($dataInfo, $customerID, $deliveryID,  $customerAddrID, $deliveryAddrID){
    if(empty($dataInfo)) return null;
    $decryptString = (!empty($dataInfo['response']))? Crypt::decryptString($dataInfo['response']) : null;
    $Prices = (!empty($dataInfo['Prices']))? $dataInfo['Prices'] : null;
    $PaymentCallBack = json_decode($decryptString);
    $data = array(
      'orderDate' => date('Y-m-d'),
      'customerID' => $customerID,
      'customerAddrID' => $customerAddrID,
      'deliveryID' => $deliveryID,
      'deliveryAddrID' => $deliveryAddrID,
      'totalproducts' => (!empty($dataInfo['Checkout'])) ? count($dataInfo['Checkout']) : 0,
      'delivery' => (!empty($Prices->Delivery)) ? $Prices->Delivery : 0,
      'totalincDel' => (!empty($PaymentCallBack->cost)) ? $PaymentCallBack->cost : 0,
      'vat' => (!empty($Prices->Vat)) ? $Prices->Vat : 0,
      'total' => (!empty($Prices->ProductTotal)) ? $Prices->ProductTotal : 0,
      'status' => 'Ordered',
      'paymentType' => (!empty($PaymentCallBack->cardType)) ? $PaymentCallBack->cardType: '' ,
      'lead' => 'Online',
      'delivery_date' => $dataInfo['decryptIndo']->del_date,
      'ip' => (!empty($PaymentCallBack->ipAddress)) ? $PaymentCallBack->ipAddress : '',
      'transId' => (!empty($PaymentCallBack->transId)) ? $PaymentCallBack->transId : '',
      'created_at' => date('Y-m-d H:i:s'),
      'token' => $dataInfo['token']
    );
    $SalesID = SalesHeader::Insert($data);
    return $SalesID;
  }

  private function InsertSalesOrderLines($dataInfo, $SalesID){
    if(empty($dataInfo)) return null;
    $OrderLineID = null;
    if(!empty($dataInfo['Checkout'])){
      foreach($dataInfo['Checkout'] as $Orderlines){
        $OrderLineID[] = $this->InsertOrderLine($Orderlines, $SalesID);
      }
    }
    return $OrderLineID;
  }

  private function InsertOrderLine($Orderlines, $SalesID){
    if(empty($Orderlines)) return null;
    $basket = $Orderlines->basket;
    $data = array(
      'salesID' => $SalesID,
      'productID' => $Orderlines->Product->id,
      'shapeID' => 0,
      'colorID' => $Orderlines->Color->id,
      'thicknessID' => $Orderlines->Thickness->id,
      'width' => $Orderlines->Width,
      'length' => $Orderlines->Length,
      'dimension' => $Orderlines->Dimension,
      'quantity' => $Orderlines->Quantity,
      'product_price' => $Orderlines->Price,
      'notes' => $Orderlines->specialRequests,
      'created_at' => date('Y-m-d H:i:s')
    );
    $SalesID = SalesLines::Insert($data);
    return $SalesID;
  }

}
