<?php


namespace App\Http\Services;
use Illuminate\Support\Facades\Mail;
use App\Mail\Orders;

class EmailService
{

  private $sendEmail = 'sales@justbuyplastic.co.uk';
  private $replyEmail = 'info@justbuyplastic.co.uk';
  private $companyName = 'Just Buy Plastic';
  private $EmailRoot = '/home/buyplast/justbuyplastic.co.uk/resources/views/emails/';

  private function buildHeaders($To = '', $name = '', $CC = '', $BCC = ''){
    // To send HTML mail, the Content-type header must be set
    $headers[] = 'MIME-Version: 1.0';
    $headers[] = 'Content-type: text/html; charset=iso-8859-1';

    // Additional headers
    $headers[] = 'To: '.strip_tags($name).' <'.strip_tags($To).'>';
    $headers[] = 'From: Just Buy Plastic <'.strip_tags($this->sendEmail).'>';
    $headers[] = 'Reply-To: Just Buy Plastic <'.strip_tags($this->replyEmail).'>';
    if(!empty($CC)) $headers[] = 'Cc: '. $CC;
    if(!empty($BCC)) $headers[] = 'Bcc: '. $BCC;
    return implode("\r\n", $headers);
  }

  public function send($to = '', $subject = '', $emailMessagePage = '', $CC = '', $BCC = ''){
    if(empty($to) || empty($subject) || empty($emailMessagePage)) return NULL;
    $Headers = $this->buildHeaders($CC, $BCC);
    $message = file_get_contents($this->EmailRoot . $emailMessagePage .'.php');
    mail($to, $subject, $message, $Headers);
  }

  public function sendEx($to = '', $name ='', $subject = '', $emailMessagePage = '', $data = array(), $CC = '', $BCC = ''){
    if(empty($to) || empty($subject) || empty($emailMessagePage)) return NULL;
    $Headers = $this->buildHeaders($to, $name, $CC, $BCC);
    $message = file_get_contents($this->EmailRoot . $emailMessagePage .'.php');
    $newMessage = (!empty($data)) ? str_replace($data['replace'], $data['with'], $message) : $message;
    ///dd($Headers);
    mail($to, $subject, $newMessage, $Headers);
  }

  public function sendSmtp($to = '', $name ='', $subject = '', $emailMessagePage = '', $data = array(), $CC = '', $BCC = ''){
    if(empty($to) || empty($subject) || empty($emailMessagePage)) return NULL;
    $this->to = $to;
    $this->name = $name;
    $this->CC = $CC;
    $this->BCC = $BCC;
    $this->subject = $subject;
    Mail::to($this->to)->send(new Orders($data));
    // Mail::send('emails.' . $emailMessagePage, $data, function ($message) {
    //     $message->to($this->to, $this->name);
    //     $message->subject($this->subject);
    //     $message->from($this->sendEmail, $this->companyName);
    //     $message->replyTo($this->sendEmail, $this->companyName);
    //     if(!empty($this->CC)) $message->cc($this->CC);
    //     if(!empty($this->BCC)) $message->bcc($this->BCC);
    // });
  }

}
