<?php

namespace App;

use DB;
use App\Shapes;
use Illuminate\Database\Eloquent\Model;

class Products extends Model
{
    //
    public static function Get($Array = null, $delimiter = ' && ', $Limit = 0, $OrderBy = '')
    {
        $exe = $strarray = array();
        if(!empty($Array)){
          foreach ($Array as $key => $val) {
              $exeName = ':'.$key;
              $exe[$exeName] = $val;
              $strarray[] = "(`$key`= $exeName)";
          }
        }
        $whereRaw = (!empty($strarray)) ? implode($delimiter, $strarray) :'1';
        if(!empty($OrderBy) && !empty($Limit)){
          if($OrderBy == 'random'){
          return DB::table('products')->whereRaw($whereRaw, $exe)->inRandomOrder()->limit($Limit)->get();
          }
          return DB::table('products')->whereRaw($whereRaw, $exe)->orderBy($OrderBy)->limit($Limit)->get();
        }
        if(!empty($OrderBy)){
          if($OrderBy == 'random'){
          return DB::table('products')->whereRaw($whereRaw, $exe)->inRandomOrder()->get();
          }
          return DB::table('products')->whereRaw($whereRaw, $exe)->orderBy($OrderBy)->get();
        }
        if(!empty($Limit)){
          return DB::table('products')->whereRaw($whereRaw, $exe)->limit($Limit);
        }
        return DB::table('products')->whereRaw($whereRaw, $exe)->get();

    }

    public static function GetLikeNot($Array = null, $delimiter = ' && ', $Limit = 0, $OrderBy = '')
    {
        $exe = $strarray = array();
        if(!empty($Array)){
          foreach ($Array as $key => $val) {
              $Valar = explode('#', $val);
              $exLikeNot = $Valar[0];
              $newVal = $Valar[1];
              $exeName = ':'.$key;
              $exe[$exeName] = $newVal;
              $strarray[] = "(`$key`$exLikeNot $exeName)";
          }
        }
        $whereRaw = (!empty($strarray)) ? implode($delimiter, $strarray) :'1';
        if(!empty($OrderBy) && !empty($Limit)){
          if($OrderBy == 'random'){
          return DB::table('products')->whereRaw($whereRaw, $exe)->inRandomOrder()->limit($Limit)->get();
          }
          return DB::table('products')->whereRaw($whereRaw, $exe)->orderBy($OrderBy)->limit($Limit)->get();
        }
        if(!empty($Limit)){
          return DB::table('products')->whereRaw($whereRaw, $exe)->limit($Limit);
        }
        return DB::table('products')->whereRaw($whereRaw, $exe)->get();

    }

    public static function GetbyID($productID)
    {
        $ProductInfo = DB::table('products')->where('id', $productID)->first();
        return $ProductInfo;
    }

    public static function GetbyProductName($Name)
    {
        $ProductInfo = DB::table('products')->where('name', $Name)->first();
        return $ProductInfo;
    }

    public static function Insert($data = null)
    {
        if (!empty($data)) {
            DB::table('products')->insert($data);
            $ProductInfo = DB::getPdo()->lastInsertId();
            return $ProductInfo;
        }
    }

    public static function UpdateProducts($productID = 0, $data = null)
    {
        if (!empty($data) && !empty($productID)) {
            $Update = DB::table('products')->where('id', $productID)->update($data);
            return $Update;
        }
    }

    public static function GetProductCategories($index = false)
    {
        $productCatagories = DB::table('product_catagories')->get();
        if(!empty($index)){
          $NewArray = null;
          foreach($productCatagories as $val){
            $NewArray[$val->id] = $val;
          }
          return $NewArray;
        }else{
          return $productCatagories;
        }
    }

    public static function GetProductCategoriesByName($name = '', $index = false)
    {
      if(!empty($name)){
        $productCatagories = DB::table('product_catagories')->where('name', $name)->first();
        if(!empty($index)){
          $NewArray = null;
          foreach($productCatagories as $val){
            $NewArray[$val->id] = $val;
          }
          return $NewArray;
        }else{
          return $productCatagories;
        }
      }
    }

    public static function GetOneProductCategory($data = null)
    {
      if(!empty($data)){
        $results = DB::table('product_catagories')
        ->where($data)
        ->first();
        return $results;
      }
    }

    public static function GetCatagoryByID($ID = 0, $index = false)
    {

      if(!empty($ID)){
        $data = array('id'=>$ID);
        $results = DB::table('product_catagories')->where($data)->first();
        if(!empty($results)){
          if(!empty($index)){
            $NewArray = null;
              $NewArray[$results->id] = $results;
            return $NewArray;
          }else{
            return $results;
          }
        }else{
          return false;
        }

      }
    }

    public static function GetAllIn($array = null, $indexKey = false)
    {
      if(empty($array)) return null;
        $fixedArray = array_filter(array_unique($array));
        $All = DB::table('products')->whereIn('id', $fixedArray)->get();
        if(!empty($indexKey)){
          if(!empty($All)){
            $NewArray = null;
            foreach($All as $one){
              $NewArray[$one->id] = $one;
            }
            return $NewArray;
          }
        }
        return $All;
    }

    public static function GetProductsByCatagoryID($ID = 0)
    {

      if(!empty($ID)){
        $data = array('productCatID'=>$ID);
        $results = DB::table('products')->where($data)->get();
        if(!empty($results)){
          return $results;
        }else{
          return false;
        }

      }
    }

    public static function UpdateProductCategoryByID($CategoryID = 0, $data = null)
    {
        if (!empty($data) && !empty($CategoryID)) {
            $Update = DB::table('product_catagories')->where('id', $CategoryID)->update($data);
            return $Update;
        }
    }

    public static function DeleteCategoryByCatagoryID($ID = 0)
    {
      if(!empty($ID)){
        $data = array('id'=>$ID);
        $results = DB::table('product_catagories')->where($data)->delete();
        return $results;
      }
    }

    public static function InsertProductCategory($request = null)
    {
      if (!empty($request->input('name'))) {
        $data = array(
          'name' => $request->name,
          'description' => $request->description
        );
        $GotOne = Products::GetOneProductCategory($data);
        if(empty($GotOne)){
          $ID = DB::table('product_catagories')->insert($data);
          return redirect()->back()->with('message','Operation Successful !');
        }else{
          return redirect()->back()->with('message','Data Allready In !');
        }
      }
    }

    public static function DeleteProductCategory($request = null)
    {

      if (!empty($request->id)) {
        $data = array('id' => $request->id);
        $GotOne = Products::GetProductsByCatagoryID($request->id);
        if(!empty($GotOne)){
          return $GotOne;
        }else{
          $results = Products::DeleteCategoryByCatagoryID($request->id);
          return $results;
        }
      }
    }

    public static function RemoveShapes($ID = 0, $results){
      if(!empty($ID)){
        $IDSql = '%'.$ID.'%';
        $AllShapes = DB::table('products')->where('product_shapes', 'like', $IDSql)->get();
        $Newresults = null;
          if(!empty($AllShapes)){
            foreach($AllShapes as $val){
              $product_shapes = Shapes::FindRebuild($val->product_shapes, $ID);
              $Data = array('product_shapes'=>$product_shapes);
              $Newresults[] = DB::table('products')->where('id', $val->id)->update($Data);
            }
          }
          if(!empty($Newresults)){
            $results = (array_sum($Newresults) > 0) ? 1 : 0;
          }
      }
      return $results;
    }

}
