<?php

namespace App;
use DB;
use Illuminate\Database\Eloquent\Model;

class SalesHeader extends Model
{
    public static function GetRange($date)
    {
        $results = DB::table('salesheader')->where('orderDate', $date);
        return $results;
    }

    public static function GetRangeEx($from, $to)
    {
        $results = DB::table('salesheader')->whereBetween('orderDate',[$from, $to])->get();
        return $results;
    }

    public static function GetAll()
    {
        $results = DB::table('salesheader')->orderBy('salesID', 'desc')->get();
        return $results;
    }

    public static function GetbysalesID($ID)
    {
        $results = DB::table('salesheader')->where('salesID', $ID)->first();
        return $results;
    }

    public static function Insert($data = null)
    {
        if (!empty($data)) {
            $results = DB::table('salesheader')->insert($data);
            $id = DB::getPdo()->lastInsertId();
            return $id;
        }
    }

    public static function UpdatebysalesID($ID = 0, $data = null)
    {
        if (!empty($data)) {
            $Update = DB::table('salesheader')->where('salesID', $ID)->update($data);
            return $Update;
        }
    }
}
