<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSalesHeaderTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('salesHeader', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8';
            $table->collation = 'utf8_unicode_ci';
            $table->increments('salesID');
            $table->dateTime('orderDate');
            $table->tinyInteger('CustomerID');
            $table->tinyInteger('customerAddrID');
            $table->tinyInteger('customerInvoiceID');
            $table->decimal('totalproducts', 5, 2);
            $table->decimal('delivery', 5, 2);
            $table->decimal('totalincDel', 5, 2);
            $table->decimal('vat', 5, 2);
            $table->decimal('total', 5, 2);
            $table->enum('status', ['Ordered', 'Processing', 'Dispatched', 'Delivered', 'Cancelled']);
            $table->string('paymentType', 100);
            $table->string('lead', 200);
            $table->dateTime('confirmationSent');
            $table->dateTime('dateAmended');
            $table->date('delivery_date');
            $table->dateTime('dateCancelled');
            $table->text('cancelledNotes');
            $table->ipAddress('ip');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('salesHeader');
    }
}
