$(document).ready(function() {
  var drEvent = $('.dropify').dropify();

  drEvent.on('dropify.errors', function(event, element) {
    alert('Has Errors!');
  });

  goToOrder();
  updateStatus();

  $('.card-active').click(function() {
    $('.cancelled-orders').addClass('hidden');
    $('.completed-orders').addClass('hidden');
    $('.active-orders').removeClass('hidden');
  })
  $('.card-completed').click(function() {
    $('.cancelled-orders').addClass('hidden');
    $('.completed-orders').removeClass('hidden');
    $('.active-orders').addClass('hidden');
  })
  $('.card-cancelled').click(function() {
    $('.cancelled-orders').removeClass('hidden');
    $('.completed-orders').addClass('hidden');
    $('.active-orders').addClass('hidden');
  })
});


function goToOrder() {
  var $viewOrder = $('.view-order');
  $viewOrder.click(function() {
    var link = $(this).attr('data-link');
    window.location.href = link;
  })
}

function updateStatus() {
  var orderStatus = $('#order-status');
  var data = orderStatus.data();
  orderStatus.change(function() {
    var val = $(this).val();
    var ID = data.id;
    $.ajax({
      url: '/api/order/' + ID + '/' + val,
      type: 'PUT',
      success: function(data) {
        console.log(data);
      }
    });
  });
}
