$(document).ready( function(){
var drEvent = $('.dropify').dropify();

drEvent.on('dropify.errors', function(event, element){
    alert('Has Errors!');
});

clearModals();

$('#insert-product').click(function(){
  $('#new-product').submit();
});

$('#insert-color').click(function(){
  $('#new-color').submit();
});

$('#insert-thickness').click(function(){
  $('#new-thickness').submit();
});

$('#insert-shape').click(function(){
  $('#new-shape').submit();
});

$('#insert-ht').click(function(){
  $('#new-ht').submit();
});

$('#insert-category').click(function(){
  $('#new-category').submit();
});

$('#update-category').click(function(){
  $('#editcategory').submit();
});

$('#update-color').click(function(){
  $('#editcolor').submit();
});
$('#update-product').click(function(){
  $('#editproduct').submit();
});

$('#update-shape').click(function(){
  $('#editshape').submit();
});

$('#update-ht').click(function(){
  $('#modifyht').submit();
});

$('.card-active').click(function(){
  $('.active-products').removeClass('hidden');
  $('.inactive-products').addClass('hidden');
})
$('.card-inactive').click(function(){
  $('.active-products').addClass('hidden');
  $('.inactive-products').removeClass('hidden');
})


$('#edit-color .img-preview .delete').click(function(){
  var Data =  $(this).data();
  var Info = $(this);
        swal({
            title: "Are you sure?",
            text: "You will not be able to recover this imaginary file!",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete it!",
            cancelButtonText: "No, cancel plx!",
            closeOnConfirm: false,
            closeOnCancel: false
        }, function(isConfirm){
            if (isConfirm) {
              RemoveImg(Data, Info);
            } else {
                swal("Cancelled", "Your imaginary file is safe :)", "error");
            }
        });
})

$('#edit-product .img-preview .delete').click(function(){
  var Data =  $(this).data();
  var Info = $(this);
        swal({
            title: "Are you sure?",
            text: "You will not be able to recover this imaginary file!",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete it!",
            cancelButtonText: "No, cancel plx!",
            closeOnConfirm: false,
            closeOnCancel: false
        }, function(isConfirm){
            if (isConfirm) {
              RemoveProductImg(Data, Info);
            } else {
                swal("Cancelled", "Your imaginary file is safe :)", "error");
            }
        });
})



function RemoveProductImg(data, Info){
  var res = 0;
  var ID = data.img;
  var API = $('#api_token').val();
  $.post( "/api/files/"+ID, {id:ID, productID:data.productid, api_token:API}, function(json) {
    if(json === '1'){
    swal("Deleted!", "Your imaginary file has been deleted.", "success");
    Info.parent('.img-preview').addClass('hidden');
    }
  });
}

function RemoveImg(data, Info){
  var res = 0;
  var ID = data.img;
  var API = $('#api_token').val();
  $.post("/api/files/"+ID, {id:ID, colorID:data.colorid, api_token:API}, function(json) {
    if(json === '1'){
    swal("Deleted!", "Your imaginary file has been deleted.", "success");
    Info.parent('.img-preview').addClass('hidden');
    }
  });
}

function EditCategoryData(ID){
  if(ID){
    $.getJSON( "/api/productcategory/"+ID, function( json ) {
      if(json.category){
        var categoryinfo = json.category;
        var form = $('#edit-category form');
        form.find("input[name=id]").val(categoryinfo.id);
        form.find("input[name=name]").val(categoryinfo.name);
        form.find("textarea[name=description]").val(categoryinfo.description);
        $('#edit-category').modal('show');
      }
   });
  }
}

function getEditHoleData(ID){
  if(ID){
    $.getJSON( "/api/holetype/"+ID, function( json ) {
      console.log(json);
      if(json.shape){
        var shapeinfo = json.shape;
        var form = $('#edit-ht form');
        form.find("input[name=id]").val(shapeinfo.id);
        form.find("input[name=name]").val(shapeinfo.name);
        form.find("input[name=price]").val(shapeinfo.price);
        $('#edit-ht').modal('show');
      }
   });
  }
}

function getEditData(ID){
  if(ID){
    $.getJSON( "/api/colors/"+ID, function( json ) {
      if(json.color){
        var colorinfo = json.color;
        var form = $('#edit-color form');
        var thickness_codes = colorinfo.thickness_codes;
        var codesArray = thickness_codes.split(',');
        form.find("input[name=id]").val(colorinfo.id);
        form.find("input[name=name]").val(colorinfo.name);
        form.find("input[name=code]").val(colorinfo.code);
        form.find('.selectpicker').selectpicker('val', codesArray);
        $('#edit-color').modal('show');
      }
      if(json.files.length){
        var fileInfo = json.files;
        var ar = ['imgOnePreview','imgtwoPreview'];
        $.each(ar, function(key, value){
          if(fileInfo[key]){
            var div = $('#'+value);
            div.find('.delete').attr('data-img',fileInfo[key].id);
            div.find('.delete').attr('data-colorid',fileInfo[key].ColorID);
            div.find('.img-preview-inner').css('background-image', 'url(/'+fileInfo[key].path_medium+')');
            div.removeClass('hidden');
          }else{
            var div = $('#'+value);
            div.find('.delete').attr('data-img','');
            div.find('.delete').attr('data-colorid','');
            div.find('.img-preview-inner').css('background-image','');
            div.addClass('hidden');
          }
        });
      }else{
        ClearEmptyImgs(ar, 'data-colorid');
      }
   });
  }
}

function ClearEmptyImgs(ar, dataID){
  $.each(ar, function(key, value){
    var div = $('#'+value);
    div.find('.delete').attr('data-img','');
    div.find('.delete').attr(dataID,'');
    div.find('.img-preview-inner').css('background-image', '');
    div.addClass('hidden');
  });
}

function getEditShapeData(ID){
  if(ID){
    $.getJSON( "/api/shapes/"+ID, function( json ) {
      if(json.shape){
        var shapeinfo = json.shape;
        var form = $('#edit-shape form');
        form.find("input[name=id]").val(shapeinfo.id);
        form.find("select[name=no_dimensions]").val(shapeinfo.no_dimensions);
        form.find("input[name=name]").val(shapeinfo.name);
        form.find("textarea[name=description]").val(shapeinfo.description);
        $('#edit-shape').modal('show');
      }
      var ar = ['imgOnePreview','imgtwoPreview'];
      if(json.files.length){
        var fileInfo = json.files;
        $.each(ar, function(key, value){
          if(fileInfo[key]){
            var div = $('#'+value);
            div.find('.delete').attr('data-img',fileInfo[key].id);
            div.find('.delete').attr('data-shapeid',fileInfo[key].ColorID);
            div.find('.img-preview-inner').css('background-image', 'url(/'+fileInfo[key].path_medium+')');
            div.removeClass('hidden');
          }else{
            var div = $('#'+value);
            div.find('.delete').attr('data-img','');
            div.find('.delete').attr('data-shapeid','');
            div.find('.img-preview-inner').css('background-image','');
            div.addClass('hidden');
          }
        });
      }else{
        ClearEmptyImgs(ar, 'data-shapeid');
      }
   });
  }
}

function clearModals(){
  $( '#edit-color' ).on("hidden.bs.modal", function () {
      var form = $('#edit-color form');
      form.find("input[name=id]").val(' ');
      form.find("input[name=name]").val(' ');
      form.find("input[name=code]").val(' ');
      form.find('.selectpicker').selectpicker('val', ' ');
      var ar = ['imgOnePreview','imgtwoPreview'];
      $.each(ar, function(key, value){
        var div = $('#'+value);
        div.addClass('hidden');
      });
   });

   $( '#edit-product' ).on("hidden.bs.modal", function () {
       var form = $('#edit-product form');
       form.find("input[name=id]").val(' ');
       form.find("input[name=name]").val(' ');
       form.find("input[name=per_kg]").val(' ');
       form.find("input[name=per_sqm]").val(' ');
       form.find("input[name=gravity]").val(' ');
       form.find("input[name=max_width]").val(' ');
       form.find("input[name=max_length]").val(' ');
       form.find("input[name=page_product]").val(' ');
       form.find("textarea[name=description]").val(' ');
       form.find('.sel-catergory .selectpicker').selectpicker('val', ' ');
       form.find('.sel-colors .selectpicker').selectpicker('val', ' ');
       var ar = ['imgOnePreview','imgTwoPreview','imgThreePreview'];
       $.each(ar, function(key, value){
         var div = $('#'+value);
         div.addClass('hidden');
       });
    });
}



function productColorArray(array){
if(array){
    var newArray = [];
    $.each(array, function (key, value) {
      newArray.push(value.colorID);
    });
    return newArray;
  }
}

function productShapesArray(str){
if(str){
    var newArray = str.split(',');
    return newArray;
  }
}

function getEditProductData(ID){
  if(ID){
    $.getJSON( "/api/product/"+ID, function( json ) {
      if(json.product){
        var productInfo = json.product;
        var form = $('#edit-product form');
        var thickness_codes = productInfo.productColors;
        var codesArray = productColorArray(json.productColors);
        var shapesArray = productShapesArray(productInfo.product_shapes);
        form.find("input[name=id]").val(productInfo.id);
        form.find("input[name=name]").val(productInfo.name);
        form.find("input[name=per_kg]").val(productInfo.price_kg);
        form.find("input[name=per_sqm]").val(productInfo.per_sqm);
        form.find("input[name=gravity]").val(productInfo.gravity);
        form.find("input[name=max_width]").val(productInfo.max_width);
        form.find("input[name=max_length]").val(productInfo.max_length);
        form.find("input[name=page_order]").val(productInfo.pageOrder);
        form.find("textarea[name=description]").val(productInfo.description);
        form.find('.sel-catergory .selectpicker').selectpicker('val', productInfo.productCatID);
        form.find('.sel-colors .selectpicker').selectpicker('val', codesArray);
        form.find('.sel-shapes .selectpicker').selectpicker('val', shapesArray);
        //form.find('.sel-thickness .selectpicker').selectpicker('val', codesArray);
        $('#edit-product').modal('show');
      }
      var ar = ['imgOnePreview','imgTwoPreview','imgThreePreview'];
      if(json.files.length){
        var fileInfo = json.files;
        $.each(ar, function(key, value){
          if(fileInfo[key]){
            var div = $('#'+value);
            div.find('.delete').attr('data-img',fileInfo[key].id);
            div.find('.delete').attr('data-productid',fileInfo[key].productID);
            div.find('.img-preview-inner').css('background-image', 'url(/'+fileInfo[key].path_medium+')');
            div.removeClass('hidden');
          }else{
            var div = $('#'+value);
            div.find('.delete').attr('data-img','');
            div.find('.delete').attr('data-productid','');
            div.find('.img-preview-inner').css('background-image','');
            div.addClass('hidden');
          }
        });
      }else{
        ClearEmptyImgs(ar, 'data-productid');
      }
   });
  }
}

function DeleteProduct(ID, Info){
  var res = 0;
  var API = $('#api_token').val();
  $.ajax({
    url: "/api/product/"+ID,
    type: 'DELETE',
    data:{id:ID, api_token:API}
  }).done(function(json) {
    if(json === '1'){
    swal("Deleted!", "This Product has been deleted.", "success");
    Info.parent().parent('tr').addClass('hidden');
    }
  });
}

function ReinstateProduct(ID, Info){
  var res = 0;
  var API = $('#api_token').val();
  $.ajax({
    url: "/api/product/"+ID,
    type: 'PUT',
    data:{id:ID, api_token:API}
  }).done(function(json) {
    if(json === '1'){
    swal("Reinstated!", "This Product has been Reinstated.", "success");
    Info.parent().parent('tr').addClass('hidden');
    }
  });
}




function DeleteColor(ID, Info){
  var res = 0;
  var API = $('#api_token').val();
  $.ajax({
    url: "/api/colors/"+ID,
    type: 'DELETE',
    data:{id:ID, api_token:API}
  }).done(function(json) {
    if(json === '1'){
    swal("Deleted!", "This Color has been deleted.", "success");
    Info.parent().parent('tr').addClass('hidden');
    }
  });
}

function DeleteThickness(ID, Info){
  var res = 0;
  var API = $('#api_token').val();
  $.ajax({
    url: "/api/thickness/"+ID,
    type: 'DELETE',
    data:{id:ID, api_token:API}
  }).done(function(json) {
    if(json === '1'){
    swal("Deleted!", "This Thickness has been deleted.", "success");
    Info.parent().parent('tr').addClass('hidden');
    }
  });
}

function DeleteHT(ID, Info){
  var res = 0;
  var API = $('#api_token').val();
  $.ajax({
    url: "/api/holetype/"+ID,
    type: 'DELETE',
    data:{id:ID, api_token:API}
  }).done(function(json) {
    if(json === '1'){
    swal("Deleted!", "This Hole Type has been deleted.", "success");
    Info.parent().parent('tr').addClass('hidden');
    }
  });
}

function DeleteShape(ID, Info){
  var res = 0;
  var API = $('#api_token').val();
  $.ajax({
    url: "/api/shapes/"+ID,
    type: 'DELETE',
    data:{id:ID, api_token:API}
  }).done(function(json) {
    if(json === '1'){
    swal("Deleted!", "This Shape has been deleted.", "success");
    Info.parent().parent('tr').addClass('hidden');
    }
  });
}

function DeleteCategory(ID, Info){
  var res = 0;
  var API = $('#api_token').val();
  $.ajax({
    url: "/api/productcategory/"+ID,
    type: 'DELETE',
    data:{id:ID, api_token:API}
  }).done(function(json) {
    if(json !== '1'){
    var ar = JSON.parse(json);
    var na = [];
    $.each(ar, function(key, val){
      na.push(val.name);
    });
    var pr = (na.length > 0) ? na.join(', ') : '';
    var str = 'Please be aware that this Category is attached to the following products: <b>'+
    pr+'</b>. Before deleting this Category please unattach it from a product!';
    swal({
      html: true,
      title: 'Warning!',
      type: 'warning',
      text: str
    });
    }
    if(json === '1'){
    swal("Deleted!", "This Category has been deleted.", "success");
    Info.parent().parent('tr').addClass('hidden');
    }

  });
}

$(".btn-del-product").click(function () {
  var Info = $(this);
  var ID = $(this).data('id');
    swal({
        title: "Are you sure?",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#DD6B55",
        confirmButtonText: "Yes, delete it!",
        cancelButtonText: "No, cancel plx!",
        closeOnConfirm: false,
        closeOnCancel: false
    }, function(isConfirm){
        if (isConfirm) {
          DeleteProduct(ID, Info);
        } else {
            swal("Cancelled", "", "error");
        }
    });
});

$(".reinstate-product").click(function () {
  var Info = $(this);
  var ID = $(this).data('id');
    swal({
        title: "Are you sure?",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#DD6B55",
        confirmButtonText: "Yes, reinstate it!",
        cancelButtonText: "No, cancel plx!",
        closeOnConfirm: false,
        closeOnCancel: false
    }, function(isConfirm){
        if (isConfirm) {
          ReinstateProduct(ID, Info);
        } else {
            swal("Cancelled", "", "error");
        }
    });
});

$(".btn-del-color").click(function () {
  var Info = $(this);
  var ID = $(this).data('id');
    swal({
        title: "Are you sure?",
        text: "This color will be removed from all products!",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#DD6B55",
        confirmButtonText: "Yes, delete it!",
        cancelButtonText: "No, cancel plx!",
        closeOnConfirm: false,
        closeOnCancel: false
    }, function(isConfirm){
        if (isConfirm) {
          DeleteColor(ID, Info);
        } else {
            swal("Cancelled", "", "error");
        }
    });
});

$(".btn-del-thickness").click(function () {
  var Info = $(this);
  var ID = $(this).data('id');
    swal({
        title: "Are you sure?",
        text: "This thickness will be removed from all colors!",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#DD6B55",
        confirmButtonText: "Yes, delete it!",
        cancelButtonText: "No, cancel plx!",
        closeOnConfirm: false,
        closeOnCancel: false
    }, function(isConfirm){
        if (isConfirm) {
          DeleteThickness(ID, Info);
        } else {
            swal("Cancelled", "", "error");
        }
    });
});

$(".btn-del-holetype").click(function () {
  var Info = $(this);
  var ID = $(this).data('id');
    swal({
        title: "Are you sure?",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#DD6B55",
        confirmButtonText: "Yes, delete it!",
        cancelButtonText: "No, cancel plx!",
        closeOnConfirm: false,
        closeOnCancel: false
    }, function(isConfirm){
        if (isConfirm) {
          DeleteHT(ID, Info);
        } else {
            swal("Cancelled", "", "error");
        }
    });
})

$(".btn-del-shape").click(function () {
  var Info = $(this);
  var ID = $(this).data('id');
    swal({
        title: "Are you sure?",
        text: "This shape will be removed from all products!",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#DD6B55",
        confirmButtonText: "Yes, delete it!",
        cancelButtonText: "No, cancel plx!",
        closeOnConfirm: false,
        closeOnCancel: false
    }, function(isConfirm){
        if (isConfirm) {
          DeleteShape(ID, Info);
        } else {
            swal("Cancelled", "", "error");
        }
    });
});

$(".btn-del-category").click(function () {
  var Info = $(this);
  var ID = $(this).data('id');
    swal({
        title: "Are you sure?",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#DD6B55",
        confirmButtonText: "Yes, delete it!",
        cancelButtonText: "No, cancel plx!",
        closeOnConfirm: false,
        closeOnCancel: false
    }, function(isConfirm){
        if (isConfirm) {
          DeleteCategory(ID, Info);
        } else {
            swal("Cancelled", "", "error");
        }
    });
});

$(".edit-category").click(function () {
        var ID = $(this).data('id');
        EditCategoryData(ID);
});

$(".edit-modal").click(function () {
        var ID = $(this).data('id');
        getEditData(ID);
});


$(".edit-product").click(function () {
        var ID = $(this).data('id');
        getEditProductData(ID);
});

$(".edit-shape").click(function () {
        var ID = $(this).data('id');
        getEditShapeData(ID);
});

$(".btn-edit-holetype").click(function () {
        var ID = $(this).data('id');
        getEditHoleData(ID);
});

});
