@extends('layouts.admin')

@section('css')
<link href="/assets/plugins/footable/css/footable.core.css" rel="stylesheet">
<link href="/assets/plugins/bootstrap-select/bootstrap-select.min.css" rel="stylesheet" />
<link rel="stylesheet" href="/assets/plugins/dropify/dist/css/dropify.min.css">
<link href="/assets/plugins/sweetalert/sweetalert.css" rel="stylesheet" type="text/css">
@endsection

@section('js')
<!-- Footable -->
<script src="/assets/plugins/footable/js/footable.all.min.js"></script>
<script src="/assets/plugins/bootstrap-select/bootstrap-select.min.js" type="text/javascript"></script>
<script src="/assets/plugins/sweetalert/sweetalert.min.js" type="text/javascript"></script>
<!--FooTable init-->
<script src="/assets/js/footable-init.js"></script>
<script src="/assets/plugins/dropify/dist/js/dropify.min.js"></script>
<script src="/assets/js/custom-file-input.js"></script>
<script src="/assets/js/products.js?v={{ env('GLOBALVER') }}"></script>
@endsection

@section('content')
<!-- ============================================================== -->
<!-- Start Page Content -->
<!-- ============================================================== -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">List of Product Categoires</h4>
                <div class="table-responsive table-compact">
                    <table id="demo-foo-addrow" class="table m-t-30 table-hover no-wrap contact-list" data-page-size="10">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <th class="des-max">Description</th>
                                <th>Date Created</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                          @foreach ($categories as $catergory)
                            <tr>
                                <td>{{ $catergory->id }}</td>
                                <td>{{ $catergory->name }}</td>
                                <td class="des-max">{{ str_limit($catergory->description, $limit = 50, $end = '...') }}</td>
                                <td>{{ $catergory->date_created }}</td>
                                <td><button type="button" class="btn btn-sm btn-icon btn-pure btn-outline edit-category"  data-id="{{ $catergory->id }}"><i class="ti-pencil-alt" aria-hidden="true"></i></button><button type="button" class="btn btn-sm btn-icon btn-pure btn-outline btn-del-category"  data-id="{{ $catergory->id }}"><i class="ti-close" aria-hidden="true"></i></button>
                                </td>
                            </tr>
                              @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="2">
                                    <button type="button" class="btn btn-info btn-rounded" data-toggle="modal" data-target="#add-contact">Add New Category</button>
                                </td>
                                <td colspan="6">
                                    <div class="text-right">
                                        <ul class="pagination"> </ul>
                                    </div>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                    <div id="add-contact" class="modal fade in" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-wide">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" id="myModalLabel">Add New Category</h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                </div>
                                <div class="modal-body">
                                    <form id="new-category" method="post" enctype="multipart/form-data" class="form-horizontal form-material">
                                      {{ csrf_field() }}
                                      <input id="api_token" type="hidden" name="api_token" value="{{ $user->api_token }}">
                                      <div class="row">
                                        <div class="col-sm-12">
                                        <div class="form-group">
                                          <div class="col-md-12 m-b-20">
                                              <input type="text" class="form-control" name="name" placeholder="Category Name">
                                          </div>
                                        </div>
                                        <div class="col-md-12 m-b-20">
                                            <textarea class="form-control" name="description" placeholder="Category Description" rows="8"></textarea>
                                        </div>
                                      </div>
                                    </div>
                                  </form>
                                </div>
                                <div class="modal-footer">
                                    <button id="insert-category" class="btn btn-info waves-effect" >Insert New Category</button>
                                    <button type="button" class="btn btn-default waves-effect" data-dismiss="modal">Cancel</button>
                                </div>
                            </div>
                            <!-- /.modal-content -->
                        </div>
                        <!-- /.modal-dialog -->
                    </div>
                    <div id="edit-category" class="modal fade in" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-wide">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" id="myModalLabel">Edit Category</h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                </div>
                                <div class="modal-body">
                                    <form id="editcategory" method="post" enctype="multipart/form-data" class="form-horizontal form-material">
                                      {{ csrf_field() }}
                                      <input type="hidden" name="api_token" value="{{ $user->api_token }}">
                                      <input type="hidden" name="id" value="">
                                      <input type="hidden" name="_method" value="PUT">
                                      <div class="row">
                                        <div class="col-sm-12">
                                        <div class="form-group">
                                          <div class="col-md-12 m-b-20">
                                              <input type="text" class="form-control" name="name" placeholder="Category Name">
                                          </div>
                                        </div>
                                        <div class="col-md-12 m-b-20">
                                            <textarea class="form-control" name="description" placeholder="Category Description" rows="8"></textarea>
                                        </div>
                                      </div>
                                    </div>
                                  </form>
                                </div>
                                <div class="modal-footer">
                                    <button id="update-category" class="btn btn-info waves-effect" >Update Category</button>
                                    <button type="button" class="btn btn-default waves-effect" data-dismiss="modal">Cancel</button>
                                </div>
                            </div>
                            <!-- /.modal-content -->
                        </div>
                        <!-- /.modal-dialog -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- ============================================================== -->
<!-- End PAge Content -->
<!-- ============================================================== -->
@endsection
