@extends('layouts.admin')

@section('css')
<link href="/assets/plugins/footable/css/footable.core.css" rel="stylesheet">
<link href="/assets/plugins/bootstrap-select/bootstrap-select.min.css" rel="stylesheet" />
<link rel="stylesheet" href="/assets/plugins/dropify/dist/css/dropify.min.css">
<link href="/assets/plugins/sweetalert/sweetalert.css" rel="stylesheet" type="text/css">
@endsection

@section('js')
<!-- Footable -->
<script src="/assets/plugins/footable/js/footable.all.min.js"></script>
<script src="/assets/plugins/bootstrap-select/bootstrap-select.min.js" type="text/javascript"></script>
<script src="/assets/plugins/sweetalert/sweetalert.min.js" type="text/javascript"></script>

<!--FooTable init-->
<script src="/assets/js/footable-init.js"></script>
<script src="/assets/plugins/dropify/dist/js/dropify.min.js"></script>
<script src="/assets/js/custom-file-input.js"></script>
<script src="/assets/js/products.js?v={{ env('GLOBALVER') }}"></script>
@endsection

@section('content')
<!-- ============================================================== -->
<!-- Start Page Content -->
<!-- ============================================================== -->
<div class="row">
<div class="col-12">
<div class="card">
<div class="card-body">
<h4 class="card-title">List of current Product Colors</h4>
<div class="table-responsive">
<table id="demo-foo-addrow" class="table m-t-30 table-hover no-wrap contact-list" data-page-size="10">
    <thead>
        <tr>
            <th>ID</th>
            <th>Color</th>
            <th>Code</th>
            <th>Thicknesses</th>
            <th>Image1</th>
            <th>Image2</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
      @foreach ($colors as $color)
        <tr>
            <td>{{ $color->id }}</td>
            <td>{{ $color->name }}</td>
            <td>{{ $color->code }}</td>
            <td>{{ $color->thickness_codes }}</td>
            <td>@if (!empty($color->imgOne)) <img src="/{{ $color->imgOne }}" class="img" />@endif</td>
            <td>@if (!empty($color->imgTwo)) <img src="/{{ $color->imgTwo }}" class="img" />@endif</td>
            <td>
              <button type="button" class="btn btn-sm btn-icon btn-pure btn-outline edit-modal" data-id="{{ $color->id }}"><i class="ti-pencil-alt" aria-hidden="true"></i></button>
            <button type="button" class="btn btn-sm btn-icon btn-pure btn-del-color" data-id="{{ $color->id }}"><i class="ti-close" aria-hidden="true"></i></button>
            </td>
        </tr>
      @endforeach
    </tbody>
<tfoot>
<tr>
<td colspan="2">
  <button type="button" class="btn btn-info btn-rounded" data-toggle="modal" data-target="#add-color">Add New Color</button>
</td>
<td colspan="6">
<div class="text-right">
<ul class="pagination"> </ul>
</div>
</td>
</tr>
</tfoot>
</table>
<div id="add-color" class="modal fade in" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
<div class="modal-dialog">
<div class="modal-content">
<div class="modal-header">
<h4 class="modal-title" id="myModalLabel">Add New Color</h4>
<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
</div>
<div class="modal-body">
  <form id="new-color" method="post" enctype="multipart/form-data" class="form-horizontal form-material">
  {{ csrf_field() }}
  <input id="api_token" type="hidden" name="api_token" value="{{ $user->api_token }}">
  <div class="row">
  <div class="col-md-6">
  <div class="form-group remove-overflow">
  <div class="col-md-12 m-b-20">
    <input type="text" class="form-control" name="name" placeholder="Color Name"> </div>
  <div class="col-md-12 m-b-20">
    <input type="text" class="form-control" name="code" placeholder="Color Code"> </div>
    <div class="col-md-12 m-b-20" >
        <select class="selectpicker" name="thickness[]" multiple data-style="form-control btn-secondary">
          @foreach ($thicknesses as $thickness)
          <option value="{{ $thickness->id }}">{{ $thickness->name }}
        </option>
          @endforeach
      </select>
    </div>
  </div>
  </div>
  <div class="col-md-6 js">
  <div class="col-xs-6 m-b-20">
  <input type="file" name="imgone" id="imgone" class="dropify" /></div>
  <div class="col-xs-6 m-b-20">
    <input type="file" id="imgtwo" name="imgtwo" class="dropify" /></div>
  </div>
  </div>
  </form>
</div>
<div class="modal-footer">
<button id="insert-color" class="btn btn-info waves-effect" >Insert New Color</button>
<button type="button" class="btn btn-default waves-effect" data-dismiss="modal">Cancel</button>
</div>
</div>
<!-- /.modal-content -->
</div>
<!-- /.modal-dialog -->
</div>

<div id="edit-color" class="modal fade in" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
<div class="modal-dialog">
<div class="modal-content">
<div class="modal-header">
<h4 class="modal-title" id="myModalLabel">Edit Color</h4>
<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
</div>
<div class="modal-body">
  <form id="editcolor" method="post" enctype="multipart/form-data" class="form-horizontal form-material">
  {{ csrf_field() }}
  <input type="hidden" name="id" value="">
  <input type="hidden" name="_method" value="PUT">
  <input id="api_token" type="hidden" name="api_token" value="{{ $user->api_token }}">
  <div class="row">
  <div class="col-md-6">
  <div class="form-group remove-overflow">
  <div class="col-md-12 m-b-20">
    <input type="text" class="form-control" name="name" placeholder="Color Name"> </div>
  <div class="col-md-12 m-b-20">
    <input type="text" class="form-control" name="code" placeholder="Color Code"> </div>
    <div class="col-md-12 m-b-20" >
        <select class="selectpicker" name="thickness[]" multiple data-style="form-control btn-secondary">
          @foreach ($thicknesses as $thickness)
          <option value="{{ $thickness->id }}">{{ $thickness->name }}
        </option>
          @endforeach
      </select>
    </div>
  </div>
  </div>
  <div class="col-md-6 js">
  <div class="col-xs-6 m-b-20 col-relative">
  <div id="imgOnePreview" class="img-preview hidden">
    <div class="img-preview-inner" /><span class="delete">Remove</span></div>
  </div>
  <input type="file" name="imgone" id="imgone" class="dropify" /></div>
  <div class="col-xs-6 m-b-20 col-relative">
  <div id="imgtwoPreview" class="img-preview hidden">
    <div class="img-preview-inner" /><span class="delete">Remove</span></div>
  </div>
    <input type="file" id="imgtwo" name="imgtwo" class="dropify" /></div>
  </div>
  </div>
  </form>
</div>
<div class="modal-footer">
<button id="update-color" class="btn btn-info waves-effect" >Update Color</button>
<button type="button" class="btn btn-default waves-effect" data-dismiss="modal">Cancel</button>
</div>
</div>
<!-- /.modal-content -->
</div>
<!-- /.modal-dialog -->
</div>
</div>
</div>
</div>
</div>
</div>
<!-- ============================================================== -->
<!-- End PAge Content -->
<!-- ============================================================== -->
@endsection
