@extends('layouts.shop')

@section('meta')
<title>Our Products | Just Buy Plastic | Plastic Supplier in Bolton, UK</title>
<meta name="description" content="Our Products Just Buy Plastic is a five-star rated plastic supplier based in Bolton, offering you everything from acrylic sheets to polycarbonate, PVC and even nylon. Buy online today!">
@endsection

@section('ogmeta')
<meta property="og:title" content="Our Products | Just Buy Plastic | Plastic Supplier in Bolton, UK">
<meta property="og:description" content="Our Products Just Buy Plastic is a five-star rated plastic supplier based in Bolton, offering you everything from acrylic sheets to polycarbonate, PVC and even nylon. Buy online today!">
@endsection

@section('css')

@endsection

@section('js')

@endsection

@section('content')
<div class="row">
    <div class="col-lg-7 col-md-6 hidden-sm hidden-xs">
        <div id="flowerCarousel" class="carousel slide" data-ride="carousel">
            <!-- Indicators -->
            <ol class="carousel-indicators">
                <li data-target="#flowerCarousel" data-slide-to="0" class="active"></li>
                <li data-target="#flowerCarousel" data-slide-to="1"></li>
                <li data-target="#flowerCarousel" data-slide-to="2"></li>
            </ol>
            <!-- Wrapper for slides -->
            <div class="carousel-inner full-width-img" role="listbox">
                <div class="item active" data-link="#">
                    <img src="/assets/images/slides/office.jpg" alt="Polycarbonate Office Wall">
                </div>
                <div class="item" data-link="#">
                    <img src="/assets/images/slides/statue.jpg" alt="Cast Acrylic Statue">
                </div>
                <div class="item" data-link="#">
                    <img src="/assets/images/slides/letters.jpg" alt="Foam PVC Letters">
                </div>
            </div>
        </div><!--! end of #panel -->
    </div>
    <div class="col-lg-5 col-md-6 col-pad-l-5">
@include('includes.shop.quote');
    </div>
</div>
<section id="bestSellers">
    <div class="row">
        <div class="col-sm-6 col-pad-lr-10 hidden-xs">
            <h3>Some of our best selling Products</h3>
        </div>
        <div class="col-sm-6 col-pad-lr-10 hidden-xs">
            <p class="text-right crafted">Crafted &amp; cut to your specification</p>
        </div>
        <div class="col-sm-12 col-pad-lr-10 hidden-xs">
            <hr>
        </div>
    </div>
    <div class="row">
        @foreach ($bestSellers as $Product)
        <div class="col-md-4 col-sm-6 col-ms-6 col-pad-lr-10">
            <div class="home-gallery" data-link="https://www.justbuyplastic.co.uk{{ $Product->link }}">
                <div class="home-gal-img">
                  <div id="imgOnePreview" class="img-preview">
                    <div class="order-now"><span>Order Now</span></div>
                      <div class="img-preview-inner" title="{{ $Product->name }}" style="background-image: url(/{{ $Product->mainImg }});"></div>
                    </div>
                    <div class="hs-box hidden"></div>
                </div>
                <div class="home-gal-text">
                    <h4 class="product-title">{{ $Product->name }}</h4>
                    <p>{{ $Product->short_description }}</p>
                    <!-- <p class="home-gal-price">from <span class="price"><span class=currsym>&pound;</span>
                            <span class=curr data-d2f-curr="27.00">27.00</span></span></p> -->
                </div>
            </div>
        </div>
        @endforeach
    </div>
</section> <! --- End Best Sellers Section --->
@endsection
