<?php
use Illuminate\Http\Request;
use App\Colors;
use App\Files;
use App\Http\Controllers\ProductsController;
use App\Http\Controllers\ColorsController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {return $request->user();});

// Products
Route::get('product/{id}', 'ProductsController@GetByID')->where('id', '[0-9]+');
Route::get('product/{name}', 'ProductsController@GetByName');

Route::middleware('auth:api')->post('product', function (Request $request) {
  print_r($request);
});
Route::middleware('auth:api')->delete('product/{id}', function (Request $request) {
$results = ProductsController::DeleteProduct($request->id);
echo $results;
})->where('id', '[0-9]+');

Route::middleware('auth:api')->put('product/{id}', function (Request $request) {
$results = ProductsController::ResinstateProduct($request->id);
echo $results;
})->where('id', '[0-9]+');

Route::put('order/{salesID}/{status}', 'OrderController@updateStatus')->where('salesID', '[0-9]+');

// Thickness

Route::get('thickness/{id}', 'ThicknessController@getByID')->where('id', '[0-9]+');
Route::get('thickness/{str}', 'ThicknessController@getByArray');
Route::get('thickness/all', 'Thickness@GetAll');

Route::middleware('auth:api')->post('thickness/insert', 'Thickness@Insert');
Route::middleware('auth:api')->post('thickness/{id}', 'Thickness@Update')->where('id', '[0-9]+');
Route::middleware('auth:api')->delete('thickness/{id}', 'ThicknessController@DeleteThickness')->where('id', '[0-9]+');

// Hole Type
Route::get('holetype/all', 'HoletypeController@GetAll');
Route::get('holetype/{id}', 'HoletypeController@GetByID')->where('id', '[0-9]+');
Route::middleware('auth:api')->delete('holetype/{id}', 'HoletypeController@DeleteHT')->where('id', '[0-9]+');

// Shapes
Route::get('shapes/{id}', 'ShapeController@GetByID')->where('id', '[0-9]+');
Route::get('shapes/all', 'ShapeController@GetAll');
Route::middleware('auth:api')->post('shape', 'Shapes@Insert');
Route::middleware('auth:api')->delete('shapes/{id}', 'ShapeController@DeleteShape')->where('id', '[0-9]+');

// Colors
Route::get('colors/{id}', function ($id) {
  $array['color'] = Colors::Get($id);
  $array['files'] = Files::GetFilebyColorID($id);
  echo json_encode($array);
})->where('id', '[0-9]+');
Route::get('colors/all', function () {
    $allcolors = Colors::GetAll();
    echo json_encode($allcolors);
});
Route::get('colors/{name}', function ($name) {
    $colors = Colors::GetbyName($name);
    echo json_encode($colors);
});
Route::get('colors/code/{code}', function ($code) {
    $color = Colors::GetbyCode($code);
    echo json_encode($color);
});
Route::middleware('auth:api')->post('color', function (request $request) {
    $results = Colors::Insert($request);
    echo json_encode($results);
});
Route::middleware('auth:api')->post('colors/{id}', function ($id) {
    $results = Colors::Update($id, request);
    echo json_encode($results);
})->where('id', '[0-9]+');
Route::middleware('auth:api')->delete('colors/{id}', function (request $request) {
        $results = ColorsController::Delete($request->id);
        echo json_encode($results);
    }
)->where('id', '[0-9]+');

//Files
Route::middleware('auth:api')->post('files/{id}', 'FilesController@UpdateFiles')->where('id', '[0-9]+');
// ProductColors
Route::get('productcolor/{id}', 'ProductColors@GetByID')->where('id', '[0-9]+');
Route::get('productcolor/product/{id}', 'ProductsController@GetPorductColorByID')->where('id', '[0-9]+');
Route::get('productcolor/all', 'ProductColors@GetAll');
Route::middleware('auth:api')->post('productcolor', 'ProductColors@Insert');
Route::middleware('auth:api')->post('productcolor/{id}', 'ProductColors@Update')->where('id', '[0-9]+');
Route::middleware('auth:api')->delete('productcolor/{id}', 'ProductColors@Delete')->where('id', '[0-9]+');

// productCategories
Route::get('productcategory/{id}', 'ProductsController@GetProductCategory')->where('id', '[0-9]+');
Route::middleware('auth:api')->post('productcategory/{id}', 'ProductsController@UpdateProductCategory')->where('id', '[0-9]+');
Route::middleware('auth:api')->delete('productcategory/{id}', 'ProductsController@DeleteProductCategory')->where('id', '[0-9]+');



// Customers
Route::get('customers/{id}', 'CustomersController@GetByID')->where('id', '[0-9]+');
Route::middleware('auth:api')->post('customer', 'CustomersController@InsertNewCustomer');
Route::middleware('auth:api')->post('customers/{id}', function ($id) {
})->where('id', '[0-9]+');
Route::middleware('auth:api')->delete('customers/{id}', function ($id) {
})->where('id', '[0-9]+');

// Checkout & Basket
Route::post('basket', 'CheckoutController@addtoBasket');
Route::delete('empty-basket/{token}', 'CheckoutController@RemoveChildToken');

// Sales
Route::get('sales/{id}', 'SalesHeaderController@getByID')->where('id', '[0-9]+');
Route::middleware('auth:api')->post('sale', function () {
});
Route::middleware('auth:api')->post('sales/{id}', function ($id) {
})->where('id', '[0-9]+');
Route::middleware('auth:api')->delete('sales/{id}', function ($id) {
})->where('id', '[0-9]+');

// Address
Route::get('postcode', 'AddressController@getAddressGoogle');
Route::post('postcode', 'AddressController@getAddressGoogle');
Route::get('ga/{postcode}', 'AddressController@getGoogleAddressbyPostcode');
Route::get('address/{id}', 'AddressController@getByID')->where('id', '[0-9]+');
Route::get('address/{postcode}', 'AddressController@getByPostcode');

Route::middleware('auth:api')->post('address', 'AddressController@Insert');
Route::middleware('auth:api')->post('address/{id}', function ($id) {
})->where('id', '[0-9]+');
Route::middleware('auth:api')->delete('address/{id}', function ($id) {
})->where('id', '[0-9]+');
Route::middleware('auth:api')->post('address/{postcode}', function ($postcode) {
});
Route::middleware('auth:api')->delete('address/{postcode}', function ($postcode) {
});

// ---- News Letter ---//

Route::post('newsletter', 'CustomersController@InsertNewNewsLetterCustomer');

// Nav Load
Route::get('/nav-load', 'ApiController@navLoad');
