<?php

namespace App;
use DB;
use Illuminate\Database\Eloquent\Model;

class Checkout extends Model
{
    public static function GetRange($date)
    {
        $results = DB::table('checkout')->where('orderDate', $date)->get();
        return $results;
    }

    public static function GetByCookieID($ID)
    {
        $results = DB::table('checkout')->where('token', $ID)->get();
        return $results;
    }

    public static function GetCountByCookieID($ID)
    {
        $results = DB::table('checkout')->where('token', $ID)->count();
        return $results;
    }

    public static function GetbysalesID($ID)
    {
        $results = DB::table('checkout')->where('salesID', $ID)->first();
        return $results;
    }

    public static function Insert($data = null)
    {
        if (!empty($data)) {
            $results = DB::table('checkout')->insert($data);
            return $results;
        }
    }

    public static function DeleteByCookie($Token)
    {
        $results = DB::table('checkout')->where('token', $Token)->delete();
        return $results;
    }

    public static function DeleteByChildCookie($Token)
    {
        $results = DB::table('checkout')->where('childToken', $Token)->delete();
        return $results;
    }

    public static function UpdatebySalesLineID($ID = 0, $data = null)
    {
        if (!empty($data)) {
            $Update = DB::table('checkout')->where('SalesLineID', $ID)->update($data);
            return $Update;
        }
    }

    public static function UpdatebysalesID($ID = 0, $data = null)
    {
        if (!empty($data)) {
            $Update = DB::table('checkout')->where('salesID', $ID)->update($data);
            return $Update;
        }
    }

    public static function DeleteByToken($Token = '')
    {
        if (!empty($Token)) {
            $results = DB::table('checkout')->where('token', $Token)->delete();
            return $results;
        }
    }
}
