<?php

namespace App\Http\Controllers;

use App\Products;
use App\Files;
use App\Thickness;
use App\Colors;
use App\Shapes;
use App\Holetypes;
use App\ProductColors;
use Cache;
use Illuminate\Http\Request;
use Intervention\Image\ImageManagerStatic as Image;
use Illuminate\Support\Facades\Storage;
use App\Http\Services\ServerService;

class ProductsController extends Controller
{

  private static $FeaturedLimit = 6;
  private static $WaitingImg = 'assets/images/awaiting-img.jpg';
  private static $Link = '/plastic-product/#id#/#productName#';

  private static $Fullday = 1440;

    public static function InsertNewProduct($request = null)
    {
      if (!empty($request)) {
        $ProductShapes = (!empty($request->shapes)) ? implode(',',$request->shapes) : '';
        $data = array(
          'name'=>$request->name,
          'productCatID' => $request->catergory,
          'price_kg' => $request->per_kg,
          'per_sqm' => $request->per_sqm,
          'gravity' => $request->gravity,
          'product_shapes' => $ProductShapes,
          'max_width' => $request->max_width,
          'max_length' => $request->max_length,
          'pageOrder' => $request->page_order,
          'created_at' => date('Y-m-d H:i:s'),
          'description' => $request->description
          );
      $results = Products::Insert($data);
      }
    return $results;
    }

    public static function UpdateProduct($productID = 0, $request = null)
    {
      $results = null;
      if (!empty($request) && !empty($productID)) {
        $ProductShapes = (!empty($request->shapes)) ? implode(',',$request->shapes) : '';
        $data = array(
          'name' => $request->name,
          'productCatID' => $request->catergory,
          'price_kg' => $request->per_kg,
          'per_sqm' => $request->per_sqm,
          'gravity' => $request->gravity,
          'productCatID' => $request->catergory,
          'product_shapes' => $ProductShapes,
          'max_width' => $request->max_width,
          'max_length' => $request->max_length,
          'pageOrder' => $request->page_order,
          'updated_at' => date('Y-m-d H:i:s'),

          'description' => $request->description
          );

      $results = Products::UpdateProducts($productID, $data);
      }
    return $results;
    }

    public static function ResinstateProduct($productID = 0)
    {
      if (empty($productID)) return false;
      $data = array('active' => 1);
      $results = Products::UpdateProducts($productID, $data);
      return $results;
    }

    public function GetAll($mergeData = false, $active = false, $inactive = false)
    {
        $orderby = 'pageOrder';
        $results = Products::Get(null, '', 0, $orderby);
        $PoductCategories = Products::GetProductCategories(true);
        if(!empty($mergeData)){
          $newResults = $active = $inactive = null;
          foreach($results as $val){
            $val->category = $PoductCategories[$val->productCatID]->name;
            $val->images = Files::GetFilebyProductID($val->id);
            $newResults[] = $val;
            if(!empty($val->active)){
              $active[] = $val;
            }
            if(empty($val->active)){
              $inactive[] = $val;
            }
          }
          $newResults['active'] = (!empty($active)) ? $active : 0;
          $newResults['inactive'] = (!empty($inactive)) ? $inactive : 0;
          return $newResults;
        }else{
          return $results;
        }

    }

    public static function GetAllwithCategoryKey($mergeData = false)
    {
        $dataArray = array('active'=>1);
        $OrderBy = 'pageOrder';
        $results = Products::Get($dataArray, '', '', $OrderBy);
        $PoductCategories = Products::GetProductCategories(true);
        if(!empty($mergeData)){
          $newResults = $active = $inactive = null;
          foreach($results as $val){
            $val->category = $PoductCategories[$val->productCatID]->name;
            $newResults[$val->category][] = $val;
          }
          return $newResults;
        }else{
          return $results;
        }

    }

    public static function GetRandomProducts($number = 9)
    {
        $dataArray = array('active'=>1);
        $orderby = 'pageOrder';
        $results = Products::Get($dataArray, '', $number, $orderby);
        $PoductCategories = Products::GetProductCategories(true);
          $newResults = $active = $inactive = $returnArray = null;
          foreach($results as $Product){
            $Product->images = Files::GetFilebyProductID($Product->id);
            $Product->mainImg = (!empty($Product->images[0])) ? $Product->images[0]->path_medium : self::$WaitingImg;
            $Product->link = str_replace(array('#productName#','#id#'), array(strtolower(str_slug($Product->name)), $Product->id), self::$Link);
            $Product->short_description = substr($Product->description, 0, 40);
            $Product->category = $PoductCategories[$Product->productCatID]->name;
            $newResults[] = $Product;
          }
          //   if(empty($number)) $number = count($newResults);
        //   $RandomArray = array_rand(0, $number);
        //   foreach($RandomArray as $val){
        //     $returnArray[] = $newResults[$val];
        //   }
          return $newResults;
    }

    public static function GetProductsbyCategoryName($categoryName = '', $index = false, $Limit = 0, $Random = false)
    {
      $return = array('Products','Category','Featured');
        $ProductCategories = Products::GetProductCategoriesByName($categoryName);
        if(!empty($ProductCategories)){
          $dataArray = array('productCatID'=>$ProductCategories->id);
          $results = Products::Get($dataArray, '', $Limit, $Random);
          if(!empty($results)){
            $newResults = $active = $inactive = null;
            foreach($results as $val){
              $val->images = Files::GetFilebyProductID($val->id);
              $val->mainImg = (!empty($val->images[0])) ? $val->images[0]->path_medium : self::$WaitingImg;
              $val->category = $ProductCategories->name;
              $val->link = str_replace(array('#productName#','#id#'), array(strtolower(str_slug($val->name)), $val->id), self::$Link);
              $val->short_description = substr($val->description, 0, 40);
              $newResults[$val->category][] = $val;
            }
            $return['Featured'] = ProductsController::GetFeaturedProducts($newResults[$val->category]);
            $return['Products'] = $newResults;
            $return['Category'] = $ProductCategories;
            return $return;
          }else{
            return $results;
          }
        }
        return $return;
    }

    public static function GetProductsbyCategoryID($categoryID = '', $index = false, $Limit = 0, $Random = false)
    {
      $return = array('Products','Category','Featured');
        if(!empty($categoryID)){
          $dataArray = array(
            'productCatID'=>$categoryID,
            'active' => '1'
          );

          $results = Products::Get($dataArray, ' && ', $Limit, $Random);
          $ProductCategory = Products::GetCatagoryByID($categoryID,1);
          if(!empty($results)){
            $newResults = $active = $inactive = null;
            foreach($results as $val){
              $val->images = Files::GetFilebyProductID($val->id);
              $val->mainImg = (!empty($val->images[0])) ? $val->images[0]->path_medium : self::$WaitingImg;
              $val->category = $ProductCategory[$val->productCatID]->name;
              $val->link = str_replace(array('#productName#','#id#'), array(strtolower(str_slug($val->name)), $val->id), self::$Link);
              $val->short_description = substr($val->description, 0, 40);
              $newResults[$val->category][] = $val;
            }
            $return['Featured'] = ProductsController::GetFeaturedProducts($newResults[$val->category]);
            $return['Products'] = $newResults;
            $return['Category'] = $ProductCategory[$categoryID];
            return $return;
          }else{
            return $results;
          }
        }
        return $return;
    }

    public static function GetProductsbyName($ProductName = '', $index = false, $Limit = 0, $Random = false)
    {
      $return = array('Product','Category','Similar');
        $ProductInfo = self::GetProductInfo(Products::GetbyProductName($ProductName));
        if(!empty($ProductInfo)){
          $ProductCategory = Products::GetCatagoryByID($ProductInfo->productCatID);
          if(!empty($ProductCategory)){

            $Limit = 3;
            $Random = 'random';
            $delimiter = ' && ';
            $SimilarArray = array(
              'productCatID' => '=#'.$ProductInfo->productCatID,
              'id' => '!=#'.$ProductInfo->id,
              'active' => '=#1'
            );
            $return['Product'] = $ProductInfo;
            $return['Category'] = $ProductCategory;
            $return['Similar'] = self::GetProductInfo(Products::GetLikeNot($SimilarArray, $delimiter, $Limit, $Random));
            return $return;
          }else{
            return $results;
          }
        }
        return $return;
    }

    public static function GetProductsbyID($ProductID = '', $index = false, $Limit = 0, $Random = false)
    {
      $return = array('Product','Category','Similar');
      $ColorFiles = '';
        $ProductInfo = self::GetProductInfo(Products::GetbyID($ProductID));
        if(!empty($ProductInfo)){
          $ProductCategory = Products::GetCatagoryByID($ProductInfo->productCatID);
          $ProductColors = ProductColors::GetbyproductID($ProductID);
          if(!empty($ProductColors)){
            $ColorIDs = $ColorIndexed = array();
            foreach($ProductColors as $Color){
              $ColorIndexed[$Color->colorID] = $Color;
              $ColorIDs[] = $Color->colorID;
            }
          }
          if(!empty($ColorIDs)){
            $ColorFiles = Files::getByInColorID($ColorIDs, true);
          }
          if(!empty($ProductCategory)){

            $Limit = 3;
            $Random = 'random';
            $delimiter = ' && ';
            $SimilarArray = array(
              'productCatID' => '=#'.$ProductInfo->productCatID,
              'id' => '!=#'.$ProductInfo->id,
              'active' => '=#1'
            );
            $return['Product'] = $ProductInfo;
            $return['ColorsInfo'] = $ColorIndexed;
            $return['ProductColors'] = $ColorFiles;
            $return['colCount'] = self::GetColorWidth($ColorFiles);
            $return['Category'] = $ProductCategory;
            $return['Similar'] = self::GetProductInfo(Products::GetLikeNot($SimilarArray, $delimiter, $Limit, $Random));
            return $return;
          }else{
            return $results;
          }
        }
        return $return;
    }

    private static function GetColorWidth($array = null)
    {
      $colCount = 3;
      if(!empty($array)){
        $Number = count($array);
        // if($Number > 1) $colCount = 5;
        // if($Number > 2) $colCount = 4;
        // if($Number > 3) $colCount = 3;
        if($Number > 4) $colCount = 2;
      }
      return $colCount;
    }

    private static function GetProductInfo($Products = null)
    {
      if(!empty($Products)){
        if(!empty($Products->id)){
          $Products->images = Files::GetFilebyProductID($Products->id);
          $Products->mainImg = (!empty($Products->images[0])) ? $Products->images[0]->path_medium : self::$WaitingImg;
          $Products->category = $Products->name;
          $Products->link = str_replace('#productName#', strtolower(urlencode($Products->name)), self::$Link);
          $Products->short_description = substr($Products->description, 0, 40);
        } else {
          foreach($Products as &$val){
            $val->images = Files::GetFilebyProductID($val->id);
            $val->mainImg = (!empty($val->images[0])) ? $val->images[0]->path_medium : self::$WaitingImg;
            $val->category = $val->name;
            $val->link = str_replace(array('#productName#','#id#'), array(strtolower(str_slug($val->name)), $val->id), self::$Link);
            $val->short_description = substr($val->description, 0, 40);
          }
        }
        return $Products;
      }
    }

    private static function GetFeaturedProducts($Products = null)
    {
      $NewProducts = null;
      if(!empty($Products)){
        $ProductCount = count($Products);
        $Limit = ($ProductCount <= self::$FeaturedLimit) ? $ProductCount : self::$FeaturedLimit;
        $array = array_rand($Products, $Limit);
        if($ProductCount == 1) $NewProducts = $Products;
        if(!empty($array)){
          foreach($array as $val){
            $NewProducts[] = $Products[$val];
          }
        }
        return $NewProducts;
      }
    }

    public function GetByID($id)
    {
        if (!empty($id)) {
          $baseKey = base64_encode("Product$id");
          $this->ID = $id;
          $value = Cache::remember($baseKey, self::$Fullday, function () {
            $array['product'] = Products::GetbyID($this->ID);
            $array['productColors'] = ProductColors::GetbyproductID($this->ID);
            $array['files'] = Files::GetFilebyProductID($this->ID);
            return $array;
          });
          ServerService::jsonEncode($value);
        }
    }

    public function GetByName($name)
    {
        if (!empty($name)) {
            $data = array('name'=>$name);
            $results = Products::Get($data);
        }
    }

    public function GetProductCategories()
    {
        $results = Products::GetProductCategories();
        return $results;
    }

    public static function AddFiles($request = null, $val = null, $key = 0, $ID = 0, $FileType = '')
    {
      if(!empty($request)  && !empty($val) && !empty($ID)){
        $newName = uniqid();
        $fileName = str_replace(' ', '-', trim($request->name)).'.'.time().'.jpg';
        switch($FileType){
          case 'products':
          $IDTitle = 'ProductID';
          break;
          case 'shapes':
          $IDTitle = 'ShapeID';
          break;
        }
        $FilePath = "files/$FileType/";
        $data = array(
          $IDTitle => $ID,
          'orignal_name'=> $fileName,
          'path'=> $FilePath. 'or/' .$newName.'.jpg',
          'path_medium'=>$FilePath. 'md/' .$newName.'-600m.jpg',
          'path_small'=>$FilePath. 'sm/' .$newName.'-200s.jpg',
        );
        $moveFile =  $newName.'.jpg';
        Files::InsertFile($data);
        $newLocation = $request->file($val)->storeAs($FilePath. 'or/', $moveFile);
        $request->$val->move(public_path($FilePath. 'or/'), $moveFile);
        Image::make($FilePath . 'or/' . $moveFile)->orientate()
        ->resize(600, null, function ($constraint){$constraint->aspectRatio();})
        ->save(public_path($data['path_medium']));
        Image::make($FilePath . 'or/' . $moveFile)->orientate()
        ->resize(200, null, function ($constraint){$constraint->aspectRatio();})
        ->save(public_path($data['path_small']));

      }

    }

    public static function UpdateProductInfo(Request $request)
    {

        $Img = array('Updateimgone','Updateimgtwo','Updateimgthree');
        $productID = $request->id;
        $res = ProductsController::UpdateProduct($productID, $request);
        if(!empty($productID)){
          ProductsController::InsertProductColors($productID, $request);
        }
        if ($request->isMethod('put') && !empty($productID)) {
            foreach ($Img as $key => $val) {
                if ($request->hasFile($val)) {
                    if ($request->file($val)->isValid()) {
                        ProductsController::AddFiles($request, $val, $key, $productID, 'products');
                    }
                }
            }
            return redirect()->back()->with('message','Operation Successful !');
        }else{
          return redirect()->back()->with('message','Data Allready In !');
        }

    }

    public static function AddNewProduct(Request $request)
    {
        $Img = array('imgone','imgtwo','imgthree');
        $ProductID = ProductsController::InsertNewProduct($request);
        if(!empty($productID)){
          ProductsController::InsertProductColors($productID, $request);
        }
        if ($request->isMethod('post') && !empty($ProductID)) {
            foreach ($Img as $key => $val) {
                if ($request->hasFile($val)) {
                    if ($request->file($val)->isValid()) {
                        ProductsController::AddFiles($request, $val, $key, $ProductID, 'products');
                    }
                }
            }
            return redirect()->back()->with('message','Operation Successful !');
        }else{
          return redirect()->back()->with('message','Data Allready In !');
        }

    }

    public static function InsertProductColors($productID, $request){
      if(!empty($request->colors)){
        ProductColors::DeleteProductID($productID);
        $results = null;
        foreach($request->colors as $val){
          $Data['colorID'] = $val;
          $Data['productID'] = $productID;
          $results[] = ProductColors::InsertProductColor($Data);
        }
        return $results;
      }
    }

    public static function DeleteProduct($productID = 0)
    {
      $results = null;
      if (!empty($productID)) {
        $data = array(
          'active' => 0
          );
      $results = Products::UpdateProducts($productID, $data);
      }
    return $results;
    }

    public static function AddNewThinkness(Request $request)
    {
      $ThicknessID = Thickness::Insert($request);
      return $ThicknessID;
    }

    public static function AddNewCategory(Request $request)
    {
        $CategoryID = Products::InsertProductCategory($request);
        return $CategoryID;
    }

    public static function AddNewHT(Request $request)
    {
      $Holetypes = Holetypes::Insert($request);
      if(!empty($Holetypes))
      return redirect()->back()->with('message','Operation Successful !');
    }

    public static function AddNewShape(Request $request)
    {
      $Img = array('imgone','imgtwo');
        $ID = Shapes::Insert($request);
        if ($request->isMethod('post') && !empty($ID)) {
            foreach ($Img as $key => $val) {
                if ($request->hasFile($val)) {
                    if ($request->file($val)->isValid()) {
                        ProductsController::AddFiles($request, $val, $key, $ID, 'shapes');
                    }
                }
            }
            return redirect()->back()->with('message','Operation Successful !');
        }
    }

    public static function UpdateShape(Request $request){
      $Img = array('imgone','imgtwo');
      $data = array(
        'name'=>$request->name,
        'no_dimensions'=>$request->no_dimensions,
        'description'=>$request->description,
        'updated_at'=>date('Y-m-d H:i:s')
      );
        $ID = Shapes::UpdateShape($request->id, $data);
        if ($request->isMethod('post') && !empty($ID)) {
            foreach ($Img as $key => $val) {
                if ($request->hasFile($val)) {
                    if ($request->file($val)->isValid()) {
                        ProductsController::AddFiles($request, $val, $key, $ID, 'shapes');
                    }
                }
            }
        }
        return redirect()->back()->with('message','Operation Successful !');
    }

    public static function UpdateProductCategory(Request $request)
    {
        $CategoryID = array('id'=>$request->id);
        $data = array(
          'name'=>$request->name,
          'description'=>$request->description,
          'date_modified'=> date('Y-m-d H:i:s')
        );
        $Updated = Products::UpdateProductCategoryByID($CategoryID, $data);
        if(!empty($Updated)){
          return redirect()->back()->with('message','Operation Successful !');
        }else{
          return redirect()->back()->with('message','Error Updating!');
        }
    }

    public static function GetProductCategory(Request $request)
    {
        $data = array('id'=>$request->id);
        $CategoryInfo = Products::GetOneProductCategory($data);
        ServerService::jsonEncode(array('category'=>$CategoryInfo));
    }

    public static function DeleteProductCategory(Request $request)
    {
        $results = Products::DeleteProductCategory($request);
        ServerService::jsonEncode($results);
    }

    public static function AddNewColor(Request $request)
    {
        $ColorID = Colors::InsertNewColor($request);
        return $ColorID;
    }

    public static function UpdateColors(Request $request)
    {
        $ColorID = Colors::UpdateColors($request);
        return $ColorID;
    }

    public static function GetPorductColorByID($id)
    {
        $ProductColorsInfo = ProductColors::GetbyproductID($id);
        return $ProductColorsInfo;
    }
}
