<?php
namespace App;

use DB;
use Illuminate\Database\Eloquent\Model;

class Shapes extends Model
{
    public static function GetAll()
    {
        $results = DB::table('shapes')
        ->get();
        return $results;
    }

    public static function GetByID($ID)
    {
      if(!empty($ID)){
        $Info = DB::table('shapes')
        ->where('id', $ID)->first();
        return $Info;
      }
    }

    public static function GetOne($data = null)
    {
      if(!empty($data)){
        $results = DB::table('shapes')
        ->where($data)
        ->first();
        return $results;
      }
    }

    public static function Insert($request = null)
    {
        if (!empty($request->name)) {
          $data = array(
            'name' => $request->name,
            'no_dimensions'=>$request->no_dimensions,
            'description'=>$request->description);
            $GotOne = Shapes::GetOne($data);
            if(empty($GotOne)){
              DB::table('shapes')
              ->insert($data);
              $ID = DB::getPdo()->lastInsertId();
              return $ID;
            }else{
              return redirect()->back()->with('message','Data Allready In !');
            }

        }
    }

    public static function FindRebuild($Str = '', $ID = 0){
      if(!empty($Str) && !empty($ID)){
        $StrArray = explode(',', $Str);
        $newArray = array_diff($StrArray, array($ID));
        $newStr = implode(',',$newArray);
        return $newStr;
      }
    }

    public static function UpdateShape($ID = 0, $data = null)
    {
        if (!empty($data)) {
            $Update = DB::table('shapes')
            ->where('id', $ID)->update($data);
            return $Update;
        }
    }

    public static function GetByArray($str = '')
    {
      if(!empty($str)){
        $results = DB::table('shapes')
        ->whereIn('id', $str)
        ->get();
        return $results;
      }
    }

    public static function DeleteByID($ID = 0)
    {
      $result = 0;
        if (!empty($ID)) {
              $result = DB::table('shapes')
              ->where('id', $ID)
              ->delete();
        }
          return $result;
    }
}
