<?php

namespace App;

use DB;
use Illuminate\Database\Eloquent\Model;

class Thickness extends Model
{
    public static function GetAll($Index = false)
    {
        $results = DB::table('thicknesses')
        ->selectRaw('id, name, created_at, CAST(name AS UNSIGNED) AS number')
        ->orderBy('number', 'asc')
        ->get();
        if(!empty($Index)){
          $newArray = null;
          foreach($results as $val){
            $newArray[$val->id] = $val;
          }
          return $newArray;
        }
        return $results;
    }

    public static function GetByID($id = 0)
    {
      if(!empty($id)){
        $results = DB::table('thicknesses')
        ->where('id', $id)
        ->first();
        return $results;
      }
    }

    public static function GetByArray($str = '')
    {
      if(!empty($str)){
        $results = DB::table('thicknesses')
        ->whereIn('id', $str)
        ->get();
        return $results;
      }
    }

    public static function GetAllIn($array = null, $indexKey = false)
    {
      if(empty($array)) return null;
        $fixedArray = array_filter(array_unique($array));
        $All = DB::table('thicknesses')->whereIn('id', $fixedArray)->get();
        if(!empty($indexKey)){
          if(!empty($All)){
            $NewArray = null;
            foreach($All as $one){
              $NewArray[$one->id] = $one;
            }
            return $NewArray;
          }
        }
        return $All;
    }

    public static function GetOne($data = null)
    {
      if(!empty($data)){
        $results = DB::table('thicknesses')
        ->where($data)
        ->first();
        return $results;
      }
    }

    public static function Insert($request = null)
    {
        if (!empty($request->input('name'))) {
          $data = array(
            'name' => filter_var($request->input('name'), FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION).' mm'
            );
            $GotOne = Thickness::GetOne($data);
            if(empty($GotOne)){
              $ID = DB::table('thicknesses')->insert($data);
              return redirect()->back()->with('message','Operation Successful !');
            }else{
              return redirect()->back()->with('message','Data Allready In !');
            }

        }
    }

    public static function DeleteThickness($ID = 0)
    {
        if (!empty($ID)) {
              $result = DB::table('thicknesses')->where('id', $ID)->delete();
              return $result;
        }
    }

}
