 $(document).ready(function () {

    (function ($) {
        $.fn.stickyTabs = function (options) {
            var context = $(this);
            var settings = $.extend({
                getHashCallback: function (hash, btn) {
                    return hash
                }
            }, options);

            // Show the tab corresponding with the hash in the URL, or the first tab.
            var showTabFromHash = function () {
                var hash = window.location.hash;
                var selector = hash ? 'a[href="' + hash + '"]' : 'li.active > a';
                $(selector, context).tab('show');
            }

            // We use pushState if it's available so the page won't jump, otherwise a shim.
            var changeHash = function (hash) {
                if (history && history.pushState) {
                    history.pushState(null, null, '#' + hash);
                } else {
                    scrollV = document.body.scrollTop;
                    scrollH = document.body.scrollLeft;
                    window.location.hash = hash;
                    document.body.scrollTop = scrollV;
                    document.body.scrollLeft = scrollH;
                }
            }

            // Set the correct tab when the page loads
            showTabFromHash(context);

            // Set the correct tab when a user uses their back/forward button
            $(window).on('hashchange', showTabFromHash);

            // Change the URL when tabs are clicked
            $('a', context).on('click', function (e) {
                var hash = this.href.split('#')[1];
                var adjustedhash = settings.getHashCallback(hash, this);
                changeHash(adjustedhash);
            });

            return this;
        };
    }(jQuery));

    $(function () {

      if($('#productQuote').length === 0) {
        quoteBox();

      }
      homepage_product_jump();

      if ($('#productQuote').length > 0) {
          ProductquoteBox();
        // setTimeout(function(){
        //   workoutPriceFull()}, 500);

      }

        if ($('#pnlReviews').length && $('#d2f-pages').length === 0) {
            move_reviews();
            //hover_find_florists();

            setInterval(function () {
                loop_panels();
            }, 7000);
        }
        if ($('#search').length) {
            changeImgBoxSize();
            //changeImgSize();
            changeShopBoxSize();
            moveLangBox();
            go_to_product();
            go_to_florist_search_page();
        }
        if ($('.home-page-florist').length) {
            go_to_florist();
        }

        more_on_footer();
        click_limore();
        expand_small_footer();

        if ($('.ui-autocomplete').length) {
            var t = $('.ui-autocomplete').html();
            $('#auto-comp').html(t);
        }

        if ($('#gmap').length) {
            limitFloristProducts();
        }

        if ($('#flowers').length) {
            setTimeout(function () {
                findAcitve();
            }, 400);
            replaceNotes();
            toggleProductReviews();
            toggleProductFilters();
            historyTab();
        }

        if ($('#dpk').length) {
            showCal();
        }
        if ($('#d2f-pages').length) {
            buynow_products();
        }

        if ($('#fl').length) {
            onclickShow();
        }

        if ($('.flvid').length) {
            var scrolled = 0;
            swapVideos();
            ScrollVideos(scrolled);
        }

        if ($('.faqs').length) {
            changeFaqsButton();
            $(".panel-title").click(function () {
                setTimeout(function () {
                    changeFaqsButton();
                }, 400);
            });

        }
        BasketnavLinks();
        changeWidthAutoBasket();
        moveDelButton();
        click_mobile_icons();
        subscribe_newsletter();
        footer_circle_links();
        jumpto_florist_banners();
        AddImgsToDropDown();
        checkRadioButtons();
        CalcQuotePrice();
        GetHoleType();
        showPopups();
        getColorsModal();
    });
    $(window).resize(function () {
        if ($('#pnlReviews').length && $('#pnlReviews').length === 0) {
            move_reviews();
        }
        changeWidthAutoBasket();
        moveDelButton();
    });


     function homepage_product_jump() {
      if($('.home-gallery').length>0){
          $('.home-gallery').click(function () {
             var a = $(this).data('link');
            window.location.href = a;
          });
      }
    }

    function showPopups(){
      $('.fa-info-circle').click(function(){
        $(this).find('.popuptext').toggleClass("show");
      });
    }

    function getColorsModal(){
      $('.product-colors-pad').click( function () {
        var ColorID = $(this).data('id');
        $.ajax({
          url: '/api/colors/'+ColorID,
          type: 'GET',
          async: false,
          success: function(colorInfo) {
            const Info = JSON.parse(colorInfo);
            const $colorModal = $('#colorModal');
            var str = '';
            $.each(Info.files, function(key, value){
              str += '<img src="/' + value.path + '" class="modal-img" />';
            });
            $colorModal.find('.modal-title').text(Info.color.name);
            $colorModal.find('.modal-body').html(str);
          }
        });
      });

    }


    function calcValue(oldData, Spantext, Quote, $val){
      var data = {width:0, length:0};
      const baseFigures = {mm:'1', cm:'0.100000054',inches:'0.0393701'};
        data.width = ((Quote.WidthVal / baseFigures[Spantext]) * baseFigures[$val]).toFixed(2);
        data.length = ((Quote.LengthVal / baseFigures[Spantext]) * baseFigures[$val]).toFixed(2);
      return data;
    }

    function checkRadioButtons(){
      $('.chkRow [type=radio]').click(function (){
      var oldData = {};
      var newval;
      oldData.width = {type:'mm', nv: 0};
      oldData.length = {type:'mm', nv: 0};
      var val = $(this).val();
      var $spantext = $(".choose-format");
      var $QuoteWidth = $("#QuoteWidth");
      var $QuoteLength = $("#QuoteLength");
      var DataInfo = $QuoteWidth.attr('data-type');
      if(DataInfo){
        oldData = {};
        oldData.width = {
          type:$QuoteWidth.attr('data-type'),
          nv:$QuoteWidth.attr('data-nv'),
        };
        oldData.length = {
          type:$QuoteLength.attr('data-type'),
          nv:$QuoteLength.attr('data-nv'),
        };
      }
      const Quote = {};
      Quote.WidthVal = $QuoteWidth.val();
      Quote.LengthVal = $QuoteLength.val();
      const Spantext = $spantext.first().text();
      $QuoteWidth.attr({'data-type':Spantext, 'data-nv':Quote.WidthVal});
      $QuoteLength.attr({'data-type':Spantext, 'data-nv':Quote.LengthVal});
      switch(val){
        case 'quoteCM':
          newval = calcValue(oldData, Spantext, Quote, 'cm');
          $spantext.text('cm');
        break;
        case 'quoteInches':
          newval = calcValue(oldData, Spantext, Quote, 'inches');
          $spantext.text('inches');
        break;
        case 'quoteMM':
          newval = calcValue(oldData, Spantext, Quote, 'mm');
          $spantext.text('mm');
        break;
      }
      $QuoteWidth.val(newval.width);
      $QuoteLength.val(newval.length);
    });
  }

  function WorkOutArea(){
    const baseFigures = {mm:'1', cm:'0.100000054',inches:'0.0393701'};
    var returnInfo = {};
    var width = $("#QuoteWidth").val();
    var length = $("#QuoteLength").val();
    if(width > 0 && length > 0){
      returnInfo.width = width;
      returnInfo.length = length;

      const Spantext = $(".choose-format").first().text();
      returnInfo.unit = Spantext;
      width = (width / baseFigures[Spantext]);
      length = (length / baseFigures[Spantext]);
      returnInfo.sqm = ((width / 1000) * (length / 1000));
      returnInfo.liner = (returnInfo.sqm / (width / 1000));
      return returnInfo;
    }
    return false;
  }

  function highlightErrors(Info, $chooseQuotePlastic, $chooseQuoteThickness){
    var error = 0;
    if(!Info.gravity){
      $chooseQuotePlastic.addClass('error');
      error = 1;
    }
    if(!Info.thickness){
      $chooseQuoteThickness.addClass('error');
      error = 1;
    }
    var Quote = {};
    const $QuoteWidth = $('#QuoteWidth');
    const $QuoteLength = $('#QuoteLength');

    Quote.WidthVal = $QuoteWidth.val();
    Quote.LengthVal = $QuoteLength.val();

    (Quote.WidthVal > 0) ?
      $QuoteWidth.parent().removeClass('error') :
      $QuoteWidth.parent().addClass('error');
    (Quote.LengthVal > 0) ?
      $QuoteLength.parent().removeClass('error') :
      $QuoteLength.parent().addClass('error');

    if((Quote.WidthVal > 0) && (Quote.LengthVal > 0)){
      $('.errorHolder').addClass('hidden');
    }else{
      $('.errorHolder').removeClass('hidden');
      error = 1;
    }
    return error;
  }

  function redirectPage(Info){
    if(Info){
      var str = [];
      const $url = '/plastic-product/#id#/#productName#?';
      var newUrl = $url.replace('#id#', Info.productID).replace('#productName#', slug(Info.productName, '-'));
      if(Info.color) str.push('c='+Info.color);
      if(Info.thickness) str.push('t='+Info.thickness);
      if(Info.thicknessVal) str.push('tv='+Info.thicknessVal);
      if(Info.sizes.unit) str.push('u='+Info.sizes.unit);
      if(Info.sizes.length) str.push('l='+Info.sizes.length);
      if(Info.sizes.width) str.push('w='+Info.sizes.width);
      var base64 = (str) ? btoa(str.join('&')) : '';
      newUrl += (base64) ? 'q='+base64 : '';
      window.location = newUrl;
    }

  }

  function slug(title, separator) {
  	if(typeof separator == 'undefined') separator = '-';

  	// Convert all dashes/underscores into separator
  	var flip = separator == '-' ? '_' : '-';
  	title = title.replace(flip, separator);

  	// Remove all characters that are not the separator, letters, numbers, or whitespace.
  	title = title.toLowerCase()
  			.replace(new RegExp('[^a-z0-9' + separator + '\\s]', 'g'), '');

  	// Replace all separator characters and whitespace by a single separator
  	title = title.replace(new RegExp('[' + separator + '\\s]+', 'g'), separator);

  	return title.replace(new RegExp('^[' + separator + '\\s]+|[' + separator + '\\s]+$', 'g'),'');
  }

  function workoutQuotePrice(redirect){
    var error = 0;
    const AreaChosen = WorkOutArea();
    const $chooseQuotePlastic = $("#chooseQuotePlastic");
    const $chooseQuoteThickness = $("#chooseQuoteThickness");
    const $chooseQuoteColour = $("#chooseQuoteColour");
    var Info = $chooseQuotePlastic.find(":selected").data();
    if(Info){
      Info.productID = $chooseQuotePlastic.find(":selected").val();
      Info.productName = $chooseQuotePlastic.find(":selected").text();
      Info.color = $chooseQuoteColour.find(":selected").val();
      Info.thickness = $chooseQuoteThickness.find(":selected").attr('data-thinkness');
      Info.thicknessVal = $chooseQuoteThickness.find(":selected").val();
      Info.sizes = AreaChosen;
      error = highlightErrors(Info, $chooseQuotePlastic, $chooseQuoteThickness);
    }
    if(error === 0){
      const KgSqm = (parseInt(Info.thickness) * parseFloat(Info.gravity));
      const price = (AreaChosen) ? ((AreaChosen.sqm * KgSqm) * parseFloat(Info.kg)).toFixed(2) : '0.00' ;
      $(".priceSet").text(price);
      if(redirect){
        setTimeout(function(){
         redirectPage(Info);
         }, 3000);
      }
    }
  }

  function workoutPriceFull(showerrors){
    const AreaChosen = WorkOutArea();
    const $chooseQuotePlastic = $("#chooseQuotePlastic");
    const $chooseQuoteThickness = $("#chooseQuoteThickness");
    const $chooseQuoteColour = $("#chooseQuoteColour");
    var Info = $chooseQuotePlastic.find(":selected").data();
    if(Info){
      Info.productID = $chooseQuotePlastic.find(":selected").val();
      Info.productName = $chooseQuotePlastic.find(":selected").text();
      Info.color = $chooseQuoteColour.find(":selected").val();
      Info.thickness = $chooseQuoteThickness.find(":selected").attr('data-thinkness');
      Info.thicknessVal = $chooseQuoteThickness.find(":selected").val();
      Info.sizes = AreaChosen;
     const error = (showerrors) ? highlightErrors(Info, $chooseQuotePlastic, $chooseQuoteThickness) : 0;
      if(error === 0){
        const KgSqm = (parseInt(Info.thickness) * parseFloat(Info.gravity));
        var price = ((AreaChosen.sqm * KgSqm) * parseFloat(Info.kg)).toFixed(2);
        price = (AreaChosen) ? CalcExtras(price, AreaChosen) : '0.00';
        $(".priceSet").text(price);
      }
    }
  }

  function CalcExtras(price, AreaChosen){
    var newprice = price;
   if($("#holetype")){
     var tempPrice = (price * 100);
     const $screws = $("#screws");
     const $screwcovers = $("#screwcovers");
     const $rounded = $("#rounded");
     const $polished = $("#polished-edge");
     const $quantity = $("#quantity");
     const numberHoles = $("#noHoles").val();
     const holetypePrice = $("#holetype").find(':selected').attr('data-price');
     tempPrice = (tempPrice + (holetypePrice * numberHoles));
     const ScrewsPrice = $screws.attr('data-price');
     const numberScrews = $screws.find(':selected').val();
     tempPrice = (tempPrice + (ScrewsPrice * numberScrews));
     const polishedPrice = $polished.attr('data-price');
     const $wantpolished = $polished.find(':selected').val();
     if($wantpolished != 0) tempPrice = (tempPrice + (polishedPrice * AreaChosen.liner));
     const screwcoversPrice = $screwcovers.attr('data-price');
     const numberScrewcovers = $screwcovers.find(':selected').val();
     tempPrice = (tempPrice + (screwcoversPrice * numberScrewcovers));
     const roundedPrice = $rounded.attr('data-price');
     const numberRounded = $rounded.find(':selected').val();
     tempPrice = (tempPrice + (roundedPrice * numberRounded));
     const numberQuantity = $quantity.find(':selected').val();
     tempPrice = (tempPrice * numberQuantity);
     newprice = parseFloat(tempPrice / 100).toFixed(2);
   }
   return newprice;
  }

    function CalcQuotePrice(){
      if($('#productQuote')){
        workoutPriceFull(false);
      }
     $("#QuoteSubmit").click(function(){workoutQuotePrice(true)});
     if($('#productQuote').length > 0){
       $("#chooseQuoteThickness").change(function(){workoutPriceFull(false)});
       $("#QuoteWidth").change(function(){workoutPriceFull(false)});
       $("#QuoteLength").change(function(){workoutPriceFull(false)});
       $("#holetype").change(function(){workoutPriceFull(false)});
       $("#screws").change(function(){workoutPriceFull(false)});
       $("#screwcovers").change(function(){workoutPriceFull(false)});
       $("#rounded").change(function(){workoutPriceFull(false)});
       $("#polished-edge").change(function(){workoutPriceFull(false)});
       $("#noHoles").change(function(){workoutPriceFull(false)});
       $("#quantity").change(function(){workoutPriceFull(false)});
       $("#AddtoBasket").click(Submitform);
     }
    }


    function Submitform(){
      const $pnlQuote = $("#pnlQuote");
      const inputs = $pnlQuote.find("input");
      const selects = $pnlQuote.find("select");
      const Price = $('.priceSet').text();
      const $inputGroupAddon = $('.input-group-addon:first');
      var ar = [];
      if(Price === '0.00' || Price === 'NaN') return false;
      selects.each( function(){
        const value = $(this).find(':selected').val();
        const name = $(this).attr('name');
        const data = $(this).data();
        ar.push({'name':name, 'value':value})
      })
      inputs.each( function(){
        const value = $(this).val();
        const name = $(this).attr('name');
        const data = $(this).data();
        ar.push({'name':name, 'value':value, 'data':data})
      })
      ar.push({'name':'size', 'value':$inputGroupAddon.text(), 'data':null})
      ar.push({'name':'price', 'value':Price, 'data':null})
      const t = $('#productQuote').attr('data-t');
      $.post("/api/basket", {t:t, basket: JSON.stringify(ar)}, function (data) {
        if(data){
          window.location.href = `/cookie/${data}`;
        }
      });
    }
    //workoutPriceFull(false)
    function open_feefo_links(){
        $('#fption li a').click(function (e){
            e.preventDefault();
            var link = $(this).attr('href');
             $("#feefoModal .modal-body").load(link, function(){
                  open_feefo_links();
             });
        });
    }
    function jumpto_florist_banners() {
        if($('.carousel-inner').length>0){
        $('.carousel-inner .item').click(function () {
           var a = $(this).data('link');

          window.location.href = a;
        });
    }
    }

    function jumpto_checkout_page() {
        if($('.checkout-4').length>0){
        $('.hbuilt .btn-default').click(function () {
           var a = $(this).data('d2f-loc');
          window.location.href = a;
        });
    }
    }


    function remove_g_map() {
        $('#gmap').html('<div id="google_map"></div>');
    }

    function footer_circle_links() {
        $('#footer-social-c .cl-social').click(function () {
            var d = $(this).data('url');
            window.location.href = d;
        });
    }

    function popup(U) {
        var day = new Date();
        var id = day.getTime();
        eval("page" + id + " = window.open(U, '" + id + "', 'toolbar=0,scrollbars=1,location=0,statusbar=0,menubar=0,resizable=1,width=500,height=200');");
    }

    function go_to_product() {
        $('.floristItem .btnGrey').click(function () {
            var d = $(this).data('link');
            window.location.href = d;
        });
    }

    function go_to_florist() {
        $('.home-page-florist').click(function () {
            var d = $(this).data('link');
            window.location.href = d;
        });
    }

    function go_to_florist_search_page() {
        $('.florist-shop-img-inner').click(function () {
            var d = $(this).data('link');
            window.location.href = d;
        });
    }

    function historyTab() {
        $('.fp-nav-tabs').stickyTabs();
    }

    function changeProductValue(str) {
        var c = parseFloat(str.parent('dd').find('.currprice').data('d2f-curr'));
        var ct = parseFloat(str.parent('dd').find('.currprice').text());
        var sf = parseFloat($('#fee').data('d2f-curr'));
        var sft = parseFloat($('#fee').text());
        var cu = parseFloat(c + sf).toFixed(2);
        var t = parseFloat(ct + sft).toFixed(2);
        $('#total').data('d2f-curr', cu);
        $('#total').text(t);
    }

    function changeProductValueUp() {
        var st = parseFloat($('#optStandard').parent('dd').find('.currprice').text());
        var c = parseFloat($('#up').val());
        if (c < st) {
            $('#up').val(parseFloat(st).toFixed(2));
            c = st;
        }
        var sf = parseFloat($('#fee').data('d2f-curr'));
        var sft = parseFloat($('#fee').text());
        var t = parseFloat(c + sft).toFixed(2);
        // $('#total').data('d2f-curr',t);
        $('#total').text(t);
    }

    function onclickShow() {
        $('#up').on('change', function () {
            changeProductValueUp();
        });
        $('#cu').click(function () {
            $('#up').attr('disabled', false);
            changeProductValueUp();
        });
        $('#optStandard').click(function () {
            $('#up').attr('disabled', true);
            changeProductValue($(this));
        });
        $('#optMedium').click(function () {
            $('#up').attr('disabled', true);
            changeProductValue($(this));
        });
        $('#optLarge').click(function () {
            $('#up').attr('disabled', true);
            changeProductValue($(this));
        });
    }

    function toggleProductFilters() {
        $('#prodItemFil').click(function () {
            $('.fl .nav-pills').slideToggle();
        });
        $('#gallFil').click(function () {
            $('.flgal .nav-pills').slideToggle();
        });
    }

    function moveLangBox() {
        if ($('#sidebox #selcurr').length > 0) {
            var s = $('#sidebox').html();
            $('#sidebox').html('');
            $('#curlang').html(s);
        }
    }

    function subscribe_newsletter() {
        $('#nwsft button').click(function (e) {
            e.preventDefault();
            var em = $('#newslsi').val(), d, c, t;
            if (em !== 'undefined') {
                $.post("/api/newsletter", {t: 1, e: em}, function (res) {
                    console.log(res);
                    $('#siupal').removeClass('hidden');
                    $('#siupal').removeClass('alert-success');
                    $('#siupal').removeClass('alert-danger');
                    c = (res.success.length > 0) ? 'alert-success' : 'alert-danger';
                    t = (res.success.length > 0) ? res.success : res.error;
                    $('#siupal').addClass(c);
                    $('#siupal').text(t);
                    setTimeout(function () {
                        $('#siupal').addClass('hidden');
                        $('#newslsi').val('');
                    }, 3000);

                });
            }
        });
    }

    function loop_panels() {
        if ($('#pnlRotate').length > 0) {
            $("#pnlRotate li").each(function () {
                var e = $(this);
                var id = e.attr('id');
                if (!e.hasClass('hidden')) {
                    e.fadeOut();
                    e.addClass('hidden');
                    var n = id.replace("tile", ""),
                            nn = (parseInt(n) === 4) ? 1 : parseInt(n) + 1;
                    var nt = $('#tile' + nn);
                    var db = nt.data('b'), dn = nt.data('n');
                    var title = (dn.length > 0) ? '<b>' + db + '</b> ' + dn : '<b>' + db + '</b>';
                    $("#pnlRotate h1").html(title);
                    nt.fadeIn();
                    nt.removeClass('hidden');
                    return false;
                }
            });
        }
    }
    function hover_find_florists() {
        if ($('#bestSellers').length > 0) {
            $('#bestSellers .home-gallery').hover(function () {
                var hs_box = $('#hsform').html();
                var h = $(this).find('.hs-box');
                h.html(hs_box);
                h.fadeIn();
                h.removeClass('hidden');
            }, function () {
                var h = $(this).find('.hs-box');
                h.fadeOut();
                h.html('');
                h.addClass('hidden');
            });
        }
    }
    function changeButtonColor() {
        $(".cat a").each(function (e) {
            var text = $(this).text();
            (text == 'Christmas Flowers') ? $(this).css({"background-color": "#d20c0d", "color": "#FFF"}) : '';
        });
    }

    function changeFaqsButton() {
        $(".panel-default").each(function () {
            var vis = $(this).children('.panel-collapse').hasClass('in');
            var id = $(this).children('.panel-heading').attr('id');
            if (vis) {
                $('#' + id + ' .fa').removeClass('fa-plus-square');
                $('#' + id + ' .fa').addClass('fa-minus-square');
            } else {
                $('#' + id + ' .fa').removeClass('fa-minus-square');
                $('#' + id + ' .fa').addClass('fa-plus-square');
            }
        });
    }

    function changeWidthAutoBasket() {
        if ($('#mobile-items-cart')) {
            var windowWidth = $(window).width();
            var hb = $('#header-info-basket-div').html();
            if (windowWidth < 543) {
                $('#mobile-items-cart').addClass('header-info');
                $('#mobile-items-cart').show();
                $('#mobile-items-cart').html(hb);

            }
            if (windowWidth > 543) {
                $('#mobile-items-cart').removeClass('header-info');
                $('#mobile-items-cart').hide();
                $('#mobile-items-cart').html('');

            }
            ;
        }
    }

    function moveDelButton() {
        if ($('#mobile-items-cart')) {
            var windowWidth = $(window).width();
            var hb = $('.del-edit-price .delete').html();
            if (windowWidth < 543) {
                $('.del-edit-price .delete').hide();
                $('.new-del').html(hb);
                $('.new-del').addClass('delete');

            }
            if (windowWidth > 543) {
                $('.del-edit-price .delete').show();
                $('.new-del').html('');
                $('.new-del').removeClass('delete');

            }
            ;
        }
    }

    function buynow_products() {
        if ($('#d_pdl')) {
            $('#d_pdl ul li').each(function () {

                var incd = '<span class="incdel">including delivery</span>', l = $(this).find('.d_pr').html(),
                        m = $(this).find('.d_lk'), t, v, i = $(this).find('.d_im img').attr('src');
                v = ConvertImgs(i);
                t = l.replace('from', '<span class="f_pr">from</span>');
                $(this).find('.d_pr').html(t);
                $(this).find('.d_im img').attr('src', v);
                $(this).find('.d_lk').html('<i class="fa fa-plus-circle"></i>Add to Basket');
                $(this).find('.d_pr').after(incd);
                m.addClass('btn');
                var all = $(this).html();
                $(this).html('<div class="oronline">' + all + '</div>');
            });
        }
    }


    function AddImgsToDropDown() {
       if($('#cty').length>0){
           $('#cty option').each(function (){
               var t = $(this);
              var d = t.val();
             t.addClass('flag-'+d);
           });
       }
    }


    function changeWidthAuto() {
        if ($('#auto-comp').length) {
            var w = $('#txtQuery').width();
            $('.ui-autocomplete').width(w);
        }
    }
    function findAcitve() {
       $(".fp-nav-tabs li").each(function () {
           var t = $(this).data('pan');
           var s = $(this).data('sel');
           var cl = ($(this).hasClass('active')) ? 1 : 0;
           if (t === 'os' && cl === 1) {
               $('#allproducts').mixItUp({
                   animation: {
                       enable: false,
                       duration: 100
                   }
               });
               return false;
           }
           if (t === 'fg' && cl === 1) {

               $('#gallery').mixItUp({
                   selectors: {
                       filter: '.filter-two'
                   }
               });
               return false;
           }
           if (t === 'fd' && cl === 1) {

               LoadGMaps();
               return false;
           }

       });
   }
   function limitFloristProducts() {
       $(".div-products-desc").each(function () {
           var t = $(this).text(), m = 70;
           var newtxt = (t.length > m) ? t.substr(0, m) + '...' : t;
           $(this).text(newtxt);
       });
   }

   function LoadGMaps() {
       var flon = $('#gmap').data('lon'), flat = $('#gmap').data('lat');
       var latlng = new google.maps.LatLng(flat, flon);
       var myOptions = {
           center: latlng,
           mapTypeControl: false,
           mapTypeId: google.maps.MapTypeId.ROADMAP,
           navigationControl: true,
           navigationControlOptions: {style: google.maps.NavigationControlStyle.SMALL},
           zoom: 11
       };
       var map = new google.maps.Map(document.getElementById("google_map"), myOptions);
       var image = new google.maps.MarkerImage('/template/1005/images/marker.png',
               new google.maps.Size(156, 84),
               new google.maps.Point(0, 0),
               new google.maps.Point(78, 75));
       var marker = new google.maps.Marker({
           map: map,
           position: latlng,
           icon: image
       })
   }
   function move_reviews() {
       var w = $(window).width();
       if (w < 528) {
           var reviews = $('#pnlReviews').html();
           if ($('#pnlReviews').html().length > 70) {
               $('#low-reviews').html(reviews);
           }
           if ($('#low-reviews').html().length > 70) {
               $('#pnlReviews').html('');
           }
       }
       if (w > 528) {
           var reviews = $('#low-reviews').html();
           if (reviews.length > 70) {
               $('#pnlReviews').html(reviews);
           }
           if ($('#pnlReviews').html().length > 70) {
               $('#low-reviews').html('');
           }
       }

   }


   function expand_small_footer() {
       $('.footer-h3').click(function () {
           var dataLink = $(this).data('ul');
           if (dataLink.length > 0) {
               $("#" + dataLink).slideToggle("slow", function () {
                   if ($("#" + dataLink).css('display') !== 'none') {
                       $(this).parent('.col-md-20').find('.footer-h3').find('i').addClass('fa-arrow-circle-up');
                       $(this).parent('.col-md-20').find('.footer-h3').find('i').removeClass('fa-arrow-circle-down');
                   }

                   if ($("#" + dataLink).css('display') === 'none') {
                       $(this).parent('.col-md-20').find('.footer-h3').find('i').addClass('fa-arrow-circle-down');
                       $(this).parent('.col-md-20').find('.footer-h3').find('i').removeClass('fa-arrow-circle-up');
                   }
               });
           }
       });
   }


   function click_mobile_icons() {
       $('.quicklinks-nav .circleBase').click(function () {
           var n = $(this).data('qln');
           $.get("/api/nav-load", {n: n}, function (data) {
               var source = $(data);
               var i = source.find('#mv-'+n);
               console.log(i);
               if (i && i.length > 0) {
                   check_other_icon_open(n, i);
                   $("#mobile-action").slideToggle("slow", function () {
                       mobile_slide_add_data($(this), n);
                       if ($(".navbar-collapse").css('display') !== 'none') {
                           $(".navbar-collapse").slideUp();
                       }
                   });
               }
           });
       });
   }

   function mobile_slide_add_data(info, n) {
       if ($("#mobile-action").css('display') === 'none') {
           $(info).hide();
           $("#mobile-action").attr("data-ma", "");
       } else {
           $(info).show();
           $("#mobile-action").attr("data-ma", n);
       }
       ;
   }

   function check_other_icon_open(n, i) {
       var ma = $("#mobile-action").attr("data-ma");
       if ((n !== ma) && ma !== '') {
           $("#mobile-action").slideUp(function () {
               $("#mobile-action").html(i);
           });
           $("#mobile-action").attr("data-ma", "");
       } else {
           $("#mobile-action").html(i);
       }
   }




   function changeImgBoxSize() {
       $('.florist-products-img-outter').each(function () {
           var width;
           width = $(this).css('width');
           $(this).css('height', width);
       });
   }

   function changeShopBoxSize() {
       $('.florist-row .photo').each(function () {
           var width;
           width = $(this).css('width');
           $(this).css('height', width);
       });
   }

   function more_on_footer() {
       if ($('.ft-pg-li')) {
           $('.ft-pg-li .fnv-lst').each(function () {
               footer_li($(this).attr('id'));
           })
       }

   }

   function footer_li(footer_ul_ID) {
       var count = $("#" + footer_ul_ID).children().length;
       if (count > 6) {
           add_more_button(footer_ul_ID);
       }
   }


   function add_more_button(footer_ul_ID) {
       var c = 0;
       $("#" + footer_ul_ID + " li").each(function () {
           var LiInfo = $(this).html();
           (c > 4) ? $(this).addClass('lispan_' + footer_ul_ID) : '';
           $(this).html(LiInfo);
           c++;
       });
       $("#" + footer_ul_ID).append('<li class="limore" data-li="' + footer_ul_ID + '">More ></li>');
   }

   function click_limore() {
       $('.limore').click(function () {
           var d = $(this).data('li');
           if ($('.lispan_' + d).css('display') === 'none') {
               $('.lispan_' + d).show();
               $(this).text('Hide <');
           } else {
               $('.lispan_' + d).hide();
               $(this).text('More >');
           }
       })
   }

   function GetThicknesses(ID, $QuoteThickness) {
     if(ID){
       $.when(
       $.get('/api/thickness/'+ID, function(ThicknessInfo){
         var thArray = JSON.parse(ThicknessInfo);
         if(thArray.id){
           var str = '<option data-thinkness="'+thArray.number_only+'" value="'+thArray.id+'">'+thArray.name+'</option>';
           $QuoteThickness.append(str);
         }else{
           var str = '<option value=""> -- </option>';
           $QuoteThickness.append(str);
           $.each(thArray, function (key, val){
             var str = '<option data-thinkness="'+val.number_only+'" value="'+val.id+'">'+val.name+'</option>';
             $QuoteThickness.append(str);
           });
         }
       })
     ).then( function(){
           if($QuoteThickness.data('t')){
             $QuoteThickness.val($QuoteThickness.data('t')).change();
           }
         });
     }
   }

   function GetHoleType() {
     const $HT = $('#holetype');
     if($HT){
       $.ajax({
         url: '/api/holetype/all',
         type: 'GET',
         async: false,
         success: function(HTInfo) {
           const $HTarray = HTInfo;
           $HT.removeClass('hidden');
           $.each($HTarray.holetype, function(key, Info){
             if(Info.id){
               var price = (Info.price * 100);
               var str = '<option value="'+Info.id+'" data-price="'+price+'">'+Info.name+'</option>';
               $HT.append(str);
            }
          });
          }
       });
     }
   }

   function GetColorInfo(ID, $chooseQuoteColour) {
     var ar = '';
     if(ID){
       $.ajax({
         url: '/api/colors/'+ID,
         type: 'GET',
         async: false,
         success: function(colorInfo) {
           const $colorarray = JSON.parse(colorInfo);
           const $color = $colorarray.color;
             if($color.id){
               ar = $color.thickness_codes;
               var str = '<option value="'+ID+'">'+$color.name+'</option>';
               $chooseQuoteColour.append(str);
            }
          }
       });
     }
     return ar;
   }

   function GetProductColor(ID, addColor = false) {
     if(ID){
       const $chooseQuoteColour = $('#chooseQuoteColour');
       $.get('/api/productcolor/product/'+ID, function(r){
         if(r){
           if(addColor){
             var newarray = [];
             $chooseQuoteColour.html('');
             $.when(
               $.each(r, function (key, val){
               var res = GetColorInfo(val.colorID, $chooseQuoteColour);
               newarray.push(res);
             })
           ).then(function(){
             if($chooseQuoteColour.data('s')){
               $chooseQuoteColour.val($chooseQuoteColour.data('s'));
             }
           });
             if(newarray){
               commastr = newarray.join(',');
             }
             var newstr = [];
             if(commastr){
               $QuoteThickness = $('#chooseQuoteThickness');
               $QuoteThickness.removeClass('hidden');
               $QuoteThickness.removeClass('error');
               $QuoteThickness.html(' ');
               GetThicknesses(commastr, $QuoteThickness);
             }
           }else{
             return r;
           }
         }
       });
     }
   }

   function quoteBox() {
     $('#chooseQuotePlastic').change(function(){
       $(this).removeClass('error');
       var ID = $(this).val();
       var DataInfo = $(this).find(":selected").data();
       GetProductColor(ID, true);
       setMaxSizes(DataInfo);
       CheckMaxSize(0, 0, 'mm');
     })
   }

   function setMaxSizes(DataInfo){
     const $QuoteWidth = $('#QuoteWidth');
     const $QuoteLength = $('#QuoteLength');
     $QuoteWidth.attr('data-max-width', DataInfo.width);
     $QuoteLength.attr('data-max-length', DataInfo.length);
   }

   function CheckMaxSize(width, length, unit){
     const $QuoteWidth = $('#QuoteWidth');
     const $QuoteLength = $('#QuoteLength');
     $QuoteWidth.val(width);
     $QuoteLength.val(length);
     $QuoteWidth.parent().find('span').text(unit);
     $QuoteWidth.change( function(){
       const MaxWidth = $QuoteWidth.data('max-width');
       if(parseFloat($QuoteWidth.val()) > parseFloat(MaxWidth)) $QuoteWidth.val(MaxWidth);
     })
     $QuoteLength.parent().find('span').text(unit);
     $QuoteLength.change( function(){
       const Maxlength = $QuoteLength.data('max-length');
       if(parseFloat($QuoteLength.val()) > parseFloat(Maxlength)) $QuoteLength.val(Maxlength);
     })
   }



   function ProductquoteBox() {
     const $ar = ['#chooseMM','#chooseCM','#chooseInches'];

     const $chooseQuotePlastic = $('#chooseQuotePlastic');
     const $QuoteWidth = $('#QuoteWidth');
     const $QuoteLength = $('#QuoteLength');
     const $chooseQuoteThickness = $('#chooseQuoteThickness');
     const $chooseQuoteColour = $('#chooseQuoteColour');
     const $chkRow = $('.chkRow');

     const ID = ($chooseQuotePlastic.data('p')) ? $chooseQuotePlastic.data('p') : false;
     const unit = ($chkRow.data('u')) ? $chkRow.data('u') : 'mm';
     const width = $QuoteWidth.data('w');
     const length = $QuoteLength.data('l');

     if(ID){
       $.each($ar, function(key, value){
         $(value).prop('checked', false);
       });

         switch(unit){
           case 'mm':
             $('#chooseMM').prop('checked', true);
           break;
           case 'cm':
             $('#chooseCM').prop('checked', true);
           break;
           case 'inches':
             $('#chooseInches').prop('checked', true);
           break;
         }
         $chooseQuotePlastic.val(ID);
         GetProductColor(ID, true);
         CheckMaxSize(width, length, unit);
       }else{
         quoteBox();
       }
   }


   function BasketnavLinks() {
       $('#WiredWizard li').click(function () {
           if ($(this).hasClass('complete')) {
               var stage = $(this).data('stage');
               window.location.href = '/checkout/' + stage;
           }
       });
   }


   function toggleProductReviews() {
       $('.pr-nav').click(function () {
           var state = $(this).data('nav'), next, c = 0;
           $('.product-review').each(function () {
               if ($(this).hasClass('active')) {
                   var n = $(this).data('rtab');
                   next = (state === 'prev') ? parseInt(n) - 1 : parseInt(n) + 1;
                   $(this).hide(50, function () {
                       $(this).removeClass('active');
                   });
               }
               c++;
           });
           next = (next < 0) ? c - 1 : next;
           $('.product-review').each(function () {
               if (next === c) {
                   $(this).show("slide", function () {
                       $(this).addClass('active');
                   });
                   return false;
               }
               if ($(this).data('rtab') === next) {
                   $(this).show("slide", function () {
                       $(this).addClass('active');
                   });
               }

           });
       });
   }

   function showCal() {
       var vday, gfday, emday, motherday = $("#dpk").data('mday'),
               disabledDate = $("#dpk").data('disable'),
               defaultdate = $("#dpk").data('defaultdate'),
               sun = $("#dpk").data('sun'),
               mday = new Date(motherday);
       vday = new Date("14 February 2016");
       gfday = new Date("25 March 2016");
       emday = new Date("28 March 2016");
       $("#dpk").datepicker({
           altField: "#deldate",
           altFormat: "d-M-yy",
           dateFormat: "d-M-yy",
           defaultDate: defaultdate,
           firstDay: 1,
           autoSize: false,
           minDate: 0,
           numberOfMonths: 2,
           beforeShowDay: function (input) {
               if (mday && +mday === +input && ($.inArray("5-14-2017", disabledDate) === -1)) {
                   return [true];
               }
               if (vday && +vday === +input) {
                   return [true];
               }
               if (gfday && +gfday === +input) {
                   return [false, ""];
               }
               if (emday && +emday === +input) {
                   return [false, ""];
               }
               if (!sun && input.getDay() == 0) {
                   return [false, ""];
               }
               if (disabledDate[0] != null) {
                   var m = input.getMonth(), d = input.getDate(), y = input.getFullYear();
                   if ($.inArray((m + 1) + "-" + d + "-" + y, disabledDate) != -1) {
                       return [false, ""];
                   }
               }
               return [true, ""];
           }
       });
   }

});
