@extends('layouts.admin')

@section('css')
<link href="/assets/plugins/footable/css/footable.core.css" rel="stylesheet">
<link href="/assets/plugins/bootstrap-select/bootstrap-select.min.css" rel="stylesheet" />
<link rel="stylesheet" href="/assets/plugins/dropify/dist/css/dropify.min.css">
<link href="/assets/plugins/sweetalert/sweetalert.css" rel="stylesheet" type="text/css">
@endsection

@section('js')
<!-- Footable -->
<script src="/assets/plugins/footable/js/footable.all.min.js"></script>
<script src="/assets/plugins/bootstrap-select/bootstrap-select.min.js" type="text/javascript"></script>
<script src="/assets/plugins/sweetalert/sweetalert.min.js" type="text/javascript"></script>
<!--FooTable init-->
<script src="/assets/js/footable-init.js"></script>
<script src="/assets/plugins/dropify/dist/js/dropify.min.js"></script>
<script src="/assets/js/custom-file-input.js"></script>
<script src="/assets/js/orders.js?v={{ env('GLOBALVER') }}"></script>
@endsection

@section('breadcrumbs')
<li class="breadcrumb-item"><a href="/admin/orders">All Orders</a></li>
@endsection

@section('content')
<div class="row">
<div class="col-lg-4 col-xlg-3 col-md-5">
                        <div class="card">
                            <div class="card-body">
                              <h3><b>Order Info</b></h3>
                              <hr>
                              <small class="text-muted p-t-30 db">Name</small>
                              <h6>{{ $orderInfo->CustomerData->FullName }}</h6>
                              <small class="text-muted">Email address </small>
                                <h6>{{ $orderInfo->CustomerData->email }}</h6> <small class="text-muted p-t-30 db">Phone</small>
                                <h6>+{{ $orderInfo->CustomerData->telephone }}</h6>
                                <h3><b>Delivery Info</b></h3>
                                <hr>
                                <small class="text-muted p-t-30 db">Name</small>
                                <h6>{{ $orderInfo->DeliveryData->FullName }}</h6>
                                <small class="text-muted p-t-30 db">Address</small>
                                  <h6>{{ $orderInfo->DeliveryAddress->strAddr }} {{ $orderInfo->DeliveryAddress->city }}, {{ $orderInfo->DeliveryAddress->postcode }}</h6>
                                <div class="map-box">
                                    <iframe src="https://maps.google.com/maps?&q={{ urlencode($orderInfo->DeliveryAddress->strAddr) }},{{ urlencode($orderInfo->DeliveryAddress->city) }},{{ urlencode($orderInfo->DeliveryAddress->postcode) }},gb&output=embed" width="100%" height="150" frameborder="0" style="border:0" allowfullscreen=""></iframe>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-8 col-xlg-9 col-md-7">
<div class="row">
                    <div class="col-md-12">
                        <div class="card card-body printableArea">
                            <h3><b>INVOICE</b> <span class="pull-right">#{{ $orderInfo->Invoice }}</span></h3>
                            <hr>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="pull-left">
                                        <address>
                                            <h3> &nbsp;<b class="text-danger">Justbuyplastic.co.uk</b></h3>
                                            <p class="text-muted m-l-5">9 Peaks Place,
                                                <br> Rossini Street,
                                                <br> Bolton,
                                                <br> BL1 8GJ</p>
                                        </address>
                                    </div>
                                    <div class="pull-right text-right">
                                        <address>
                                            <h3>To,</h3>
                                            <h4 class="font-bold">{{ $orderInfo->CustomerData->FullName }},</h4>
                                            <p class="text-muted m-l-30">{{ $orderInfo->CustomerAddress->strAddr }},
                                                <br> {{ $orderInfo->CustomerAddress->city }},
                                                <br> {{ $orderInfo->CustomerAddress->county }},
                                              <br> {{ $orderInfo->CustomerAddress->postcode }}</p>
                                            <p class="m-t-30"><b>Order Date :</b> <i class="fa fa-calendar"></i> {{ date('jS F, Y', strtotime($orderInfo->orderDate)) }}</p>
                                        </address>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="table-responsive m-t-40" style="clear: both;">
                                        <table class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th class="text-center">#</th>
                                                    <th>Description</th>
                                                    <th>Color</th>
                                                    <th>Thickness</th>
                                                    <th>Size</th>
                                                    <th>note</th>
                                                    <th class="text-right">Quantity</th>
                                                    <th class="text-right">Unit Inc Vat</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                              @if(!empty($orderInfo->orderLines))
                                              @foreach($orderInfo->orderLines as $key => $Lines)
                                                <tr>
                                                    <td class="text-center">{{ $key+1 }}</td>
                                                    <td>{{ $Lines->ProductInfo->name }}</td>
                                                    <td>{{ $Lines->colorInfo->name }}</td>
                                                    <td>{{ $Lines->thicknessInfo->name }}</td>
                                                    <td>W:{{ $Lines->width }}{{ $Lines->dimension }} x L:{{ $Lines->length }}{{ $Lines->dimension }}</td>
                                                    <td>{{ $Lines->notes }}</td>
                                                    <td class="text-right">{{ $Lines->quantity }}</td>
                                                    <td class="text-right">&pound;{{ $Lines->product_price }}</td>
                                                </tr>
                                                @endforeach
                                                @endif
                                            </tbody>
                                        </table>
                                     </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="pull-right m-t-30 text-right">
                                        <p>Sub - Total amount: &pound;{{ $orderInfo->total }}</p>
                                        <p>vat (20%) : &pound;{{ $orderInfo->vat }}</p>
                                        <p>Delivery : &pound;{{ $orderInfo->delivery }}</p>
                                        <hr>
                                        <h3><b>Total :</b> &pound;{{ $orderInfo->totalincDel }}</h3>
                                    </div>
                                    <div class="clearfix"></div>
                                    <hr>
                                    <div class="row">
                                      <div class="col-md-6">
                                      <select class="form-control" id="order-status" data-id="{{ $orderInfo->salesID }}"  data-status="{{ $orderInfo->status }}">
                                        <option @if($orderInfo->status == "Ordered")selected @endif value="Ordered">Ordered</option>
                                        <option @if($orderInfo->status == "Processing")selected @endif value="Processing">Processing</option>
                                        <option @if($orderInfo->status == "Dispatched")selected @endif value="Dispatched">Dispatched</option>
                                        <option @if($orderInfo->status == "Delivered")selected @endif value="Delivered">Delivered</option>
                                        <option @if($orderInfo->status == "Cancelled")selected @endif value="Cancelled">Cancelled</option>
                                      </select>
                                    </div>
                                    <div class="col-md-6">
                                    <div class="text-right">
                                        <button id="print" class="btn btn-default btn-outline" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
                                    </div>
                                  </div>
                                </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
              </div>
          </div>
@endsection
