@extends('layouts.admin')

@section('css')
<link href="/assets/plugins/footable/css/footable.core.css" rel="stylesheet">
<link href="/assets/plugins/bootstrap-select/bootstrap-select.min.css" rel="stylesheet" />
<link rel="stylesheet" href="/assets/plugins/dropify/dist/css/dropify.min.css">
<link href="/assets/plugins/sweetalert/sweetalert.css" rel="stylesheet" type="text/css">
@endsection

@section('js')
<!-- Footable -->
<script src="/assets/plugins/footable/js/footable.all.min.js"></script>
<script src="/assets/plugins/bootstrap-select/bootstrap-select.min.js" type="text/javascript"></script>
<script src="/assets/plugins/sweetalert/sweetalert.min.js" type="text/javascript"></script>
<!--FooTable init-->
<script src="/assets/js/footable-init.js"></script>
<script src="/assets/plugins/dropify/dist/js/dropify.min.js"></script>
<script src="/assets/js/custom-file-input.js"></script>
<script src="/assets/js/orders.js?v={{ env('GLOBALVER') }}"></script>
@endsection

@section('content')
<!-- ============================================================== -->
<!-- Start Page Content -->
<!-- ============================================================== -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">List of current Products</h4>
                <div class="row m-t-40">
                    <!-- Column -->
                    <div class="col-md-4">
                        <div class="card card-inverse card-success card-active">
                            <div class="box bg-info text-center">
                                <h1 class="font-light text-white">{{ count($orders['active']) }}</h1>
                                <h6 class="text-white">Current Orders</h6>
                            </div>
                        </div>
                    </div>
                    <!-- Column -->
                    @if(!empty($orders['completed']))<div class="col-md-4">
                        <div class="card card-primary card-inverse card-completed">
                            <div class="box text-center">
                                <h1 class="font-light text-white">{{ count($orders['completed']) }}</h1>
                                <h6 class="text-white">Completed Orders</h6>
                            </div>
                        </div>
                    </div>@endif
                    @if(!empty($orders['cancelled']))<div class="col-md-4">
                        <div class="card card-primary card-inverse card-cancelled">
                            <div class="box text-center">
                                <h1 class="font-light text-white">{{ count($orders['cancelled']) }}</h1>
                                <h6 class="text-white">Cancelled Orders</h6>
                            </div>
                        </div>
                    </div>@endif
                </div>
                <div class="table-responsive orders-table">
                  <div class="active-orders">
                    <table id="demo-foo-addrow" class="table m-t-30 table-hover no-wrap contact-list" data-page-size="10">
                        <thead>
                            <tr>
                                <th>ID #</th>
                                <th>Date</th>
                                <th>Required</th>
                                <th>Status</th>
                                <th>Name</th>
                                <th>Town</th>
                                <th>Postcode</th>
                                <th>Price</th>
                                <th>Vat</th>
                                <th>Delivery</th>
                                <th>Total</th>
                            </tr>
                        </thead>
                        <tbody>
                          @foreach ($orders['active'] as $order)
                            <tr class="view-order" data-link="/admin/orders/{{ $order->salesID }}">
                                <td>{{ $order->salesID }}</td>
                                <td>{{ date('d-m-Y', strtotime($order->orderDate)) }}</td>
                                <td>{{ date('d-m-Y', strtotime($order->delivery_date)) }}</td>
                                <td>{{ $order->status }}</td>
                                <td>{{ $order->FullName }}</td>
                                <td>{{ $order->Town }}</td>
                                <td>{{ $order->Postcode }}</td>
                                <td>&pound;{{ $order->total }}</td>
                                <td>&pound;{{ $order->vat }}</td>
                                <td>&pound;{{ $order->delivery }}</td>
                                <td>&pound;{{ $order->totalincDel }}</td>
                            </tr>
                            @endforeach;
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="7">
                                    <div class="text-right">
                                        <ul class="pagination"> </ul>
                                    </div>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                  </div>
                  @if(!empty($orders['completed']))<div class="completed-orders hidden">
                    <table id="demo-completed-orders" class="table m-t-30 table-hover no-wrap contact-list" data-page-size="10">
                        <thead>
                            <tr>
                              <th>ID #</th>
                              <th>Date</th>
                              <th>Required</th>
                              <th>Status</th>
                              <th>Name</th>
                              <th>Town</th>
                              <th>Postcode</th>
                              <th>Price</th>
                              <th>Vat</th>
                              <th>Delivery</th>
                              <th>Total</th>
                            </tr>
                        </thead>
                        <tbody>
                          @foreach ($orders['completed'] as $order)
                          <tr>
                            <td class="view-order" data-link="/admin/orders/{{ $order->salesID }}">{{ $order->salesID }}</td>
                            <td>{{ date('d-m-Y', strtotime($order->orderDate)) }}</td>
                            <td>{{ date('d-m-Y', strtotime($order->delivery_date)) }}</td>
                            <td>{{ $order->status }}</td>
                            <td>{{ $order->FullName }}</td>
                            <td>{{ $order->Town }}</td>
                            <td>{{ $order->Postcode }}</td>
                            <td>&pound;{{ $order->total }}</td>
                            <td>&pound;{{ $order->vat }}</td>
                            <td>&pound;{{ $order->delivery }}</td>
                            <td>&pound;{{ $order->totalincDel }}</td>
                          </tr>
                            @endforeach;
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="2">
                                </td>
                                <td colspan="7">
                                    <div class="text-right">
                                        <ul class="pagination"> </ul>
                                    </div>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                  </div>@endif
                  @if(!empty($orders['cancelled']))<div class="cancelled-orders hidden">
                    <table id="demo-cancelled-orders" class="table m-t-30 table-hover no-wrap contact-list" data-page-size="10">
                        <thead>
                            <tr>
                              <th>ID #</th>
                              <th>Date</th>
                              <th>Required</th>
                              <th>Status</th>
                              <th>Name</th>
                              <th>Town</th>
                              <th>Postcode</th>
                              <th>Price</th>
                              <th>Vat</th>
                              <th>Delivery</th>
                              <th>Total</th>
                            </tr>
                        </thead>
                        <tbody>
                          @foreach ($orders['cancelled'] as $order)
                          <tr>
                            <td class="view-order" data-link="/admin/orders/{{ $order->salesID }}">{{ $order->salesID }}</td>
                            <td>{{ date('d-m-Y', strtotime($order->orderDate)) }}</td>
                            <td>{{ date('d-m-Y', strtotime($order->delivery_date)) }}</td>
                            <td>{{ $order->status }}</td>
                            <td>{{ $order->FullName }}</td>
                            <td>{{ $order->Town }}</td>
                            <td>{{ $order->Postcode }}</td>
                            <td>&pound;{{ $order->total }}</td>
                            <td>&pound;{{ $order->vat }}</td>
                            <td>&pound;{{ $order->delivery }}</td>
                            <td>&pound;{{ $order->totalincDel }}</td>
                          </tr>
                            @endforeach;
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="2">
                                </td>
                                <td colspan="7">
                                    <div class="text-right">
                                        <ul class="pagination"> </ul>
                                    </div>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                  </div>@endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- ============================================================== -->
<!-- End PAge Content -->
<!-- ============================================================== -->
@endsection
