@extends('layouts.admin')

@section('css')
<link href="/assets/plugins/footable/css/footable.core.css" rel="stylesheet">
<link href="/assets/plugins/bootstrap-select/bootstrap-select.min.css" rel="stylesheet" />
<link rel="stylesheet" href="/assets/plugins/dropify/dist/css/dropify.min.css">
<link href="/assets/plugins/sweetalert/sweetalert.css" rel="stylesheet" type="text/css">
@endsection

@section('js')
<!-- Footable -->
<script src="/assets/plugins/footable/js/footable.all.min.js"></script>
<script src="/assets/plugins/bootstrap-select/bootstrap-select.min.js" type="text/javascript"></script>
<script src="/assets/plugins/sweetalert/sweetalert.min.js" type="text/javascript"></script>
<!--FooTable init-->
<script src="/assets/js/footable-init.js"></script>
<script src="/assets/plugins/dropify/dist/js/dropify.min.js"></script>
<script src="/assets/js/custom-file-input.js"></script>
<script src="/assets/js/products.js?v={{ env('GLOBALVER') }}"></script>
@endsection

@section('content')
<!-- ============================================================== -->
<!-- Start Page Content -->
<!-- ============================================================== -->
<div class="row">
<div class="col-12">
<div class="card">
<div class="card-body">
<h4 class="card-title">List of Product Shapes</h4>
  <div class="table-responsive">
  <table id="demo-foo-addrow" class="table m-t-30 table-hover no-wrap contact-list" data-page-size="10">
      <thead>
          <tr>
              <th>ID</th>
              <th>Shape</th>
              <th>Created</th>
              <th>Action</th>
          </tr>
      </thead>
      <tbody>
        @foreach ($shapes as $shape)
          <tr>
              <td>{{$shape->id}}</td>
              <td>{{$shape->name}}</td>
              <td>{{$shape->created_at}}</td>
              <td>@if (!empty($shape->imgOne)) <img src="/{{ $shape->imgOne }}" class="img" />@endif</td>
              <td>@if (!empty($shape->imgTwo)) <img src="/{{ $shape->imgTwo }}" class="img" />@endif</td>
              <td>
                <button type="button" class="btn btn-sm btn-icon btn-pure btn-outline edit-shape" data-id="{{ $shape->id }}"><i class="ti-pencil-alt" aria-hidden="true"></i></button>
                <button type="button" class="btn btn-sm btn-icon btn-pure btn-outline btn-del-shape" data-id="{{ $shape->id }}" ><i class="ti-close" aria-hidden="true"></i></button>
              </td>
          </tr>
          @endforeach
      </tbody>
  <tfoot>
    <tr>
      <td colspan="2"><button type="button" class="btn btn-info btn-rounded" data-toggle="modal" data-target="#add-shape">Add New Shape</button>
      </td>
      <td colspan="6">
      <div class="text-right">
      <ul class="pagination"> </ul>
      </div>
      </td>
    </tr>
  </tfoot>
  </table>
  <div id="edit-shape" class="modal fade in" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-wide">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title" id="myModalLabel">Edit Shape</h4>
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
      </div>
      <div class="modal-body">
        <form id="editshape" method="post" enctype="multipart/form-data" class="form-horizontal form-material">
        {{ csrf_field() }}
        <input id="api_token" type="hidden" name="api_token" value="{{ $user->api_token }}">
        <input type="hidden" name="id" value="">
        <input type="hidden" name="_method" value="PUT">
        <div class="row">
        <div class="col-md-6">
        <div class="form-group remove-overflow">
        <div class="col-md-12 m-b-20">
          <input type="text" class="form-control" name="name" placeholder="square, t-shape etc..."> </div>
          <div class="col-md-12 m-b-20">
            <select name="no_dimensions" class="form-control">
              <option value="1">1 measurable Length</option>
              <option value="2">2 measurable Lengths</option>
              <option value="3">3 measurable Lengths</option>
              <option value="4">4 measurable Lengths</option>
              <option value="5">5 measurable Lengths</option>
              <option value="6">6 measurable Lengths</option>
              <option value="7">7 measurable Lengths</option>
              <option value="8">8 measurable Lengths</option>
              <option value="9">9 measurable Lengths</option>
              <option value="10">10 measurable Lengths</option>
            </select>
            </div>
        <div class="col-md-12 m-b-20">
          <textarea data-toggle="tooltip" title="Description" class="form-control" name="description" placeholder="Description" rows="10"></textarea> </div>
          </div>
        </div>
          <div class="col-md-6 js">
          <div class="col-xs-6 m-b-20 col-relative">
            <div id="imgOnePreview" class="img-preview hidden">
              <div class="img-preview-inner" /><span class="delete">Remove</span></div>
            </div>
          <input type="file" name="imgone" id="imgone" class="dropify" /></div>
          <div class="col-xs-6 m-b-20 col-relative">
            <div id="imgtwoPreview" class="img-preview hidden">
              <div class="img-preview-inner" /><span class="delete">Remove</span></div>
            </div>
            <input type="file" id="imgtwo" name="imgtwo" class="dropify" /></div>
          </div>
            </div>
        </form>
      </div>
      <div class="modal-footer">
        <button id="update-shape" class="btn btn-info waves-effect" >Update Shape</button>
        <button type="button" class="btn btn-default waves-effect" data-dismiss="modal">Cancel</button>
      </div>
    </div>
    <!-- /.modal-content -->
    </div>
  <!-- /.modal-dialog -->
  </div>

  <div id="add-shape" class="modal fade in" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-wide">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title" id="myModalLabel">Add New Shape</h4>
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
      </div>
      <div class="modal-body">
        <form id="new-shape" method="post" enctype="multipart/form-data" class="form-horizontal form-material">
        {{ csrf_field() }}
        <input id="api_token" type="hidden" name="api_token" value="{{ $user->api_token }}">
        <div class="row">
        <div class="col-md-6">
        <div class="form-group remove-overflow">
        <div class="col-md-12 m-b-20">
          <input type="text" class="form-control" name="name" placeholder="square, t-shape etc..."> </div>
          <div class="col-md-12 m-b-20">
            <select name="no_dimensions" class="form-control">
              <option value="1">1 measurable Length</option>
              <option value="2">2 measurable Lengths</option>
              <option value="3">3 measurable Lengths</option>
              <option value="4">4 measurable Lengths</option>
              <option value="5">5 measurable Lengths</option>
              <option value="6">6 measurable Lengths</option>
              <option value="7">7 measurable Lengths</option>
              <option value="8">8 measurable Lengths</option>
              <option value="9">9 measurable Lengths</option>
              <option value="10">10 measurable Lengths</option>
            </select>
            </div>
        <div class="col-md-12 m-b-20">
          <textarea data-toggle="tooltip" title="Description" class="form-control" name="description" placeholder="Description" rows="10"></textarea> </div>
          </div>
        </div>
          <div class="col-md-6 js">
          <div class="col-xs-6 m-b-20">
          <input type="file" name="imgone" id="imgone" class="dropify" /></div>
          <div class="col-xs-6 m-b-20">
            <input type="file" id="imgtwo" name="imgtwo" class="dropify" /></div>
          </div>
            </div>
        </form>
      </div>
      <div class="modal-footer">
        <button id="insert-shape" class="btn btn-info waves-effect" >Insert New Shape</button>
        <button type="button" class="btn btn-default waves-effect" data-dismiss="modal">Cancel</button>
      </div>
    </div>
    <!-- /.modal-content -->
    </div>
  <!-- /.modal-dialog -->
  </div>
  </div>
</div>
</div>
</div>
</div>
<!-- ============================================================== -->
<!-- End PAge Content -->
<!-- ============================================================== -->
@endsection
