<!DOCTYPE html>
<html lang="en">
    <head>
        @include('includes.admin.head')
    </head>

    <body class="fix-header fix-sidebar card-no-border">
        <!-- ============================================================== -->
        <!-- Preloader - style you can find in spinners.css -->
        <!-- ============================================================== -->
        <div class="preloader">
            <svg class="circular" viewBox="25 25 50 50">
            <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10" /> </svg>
        </div>
        <!-- ============================================================== -->
        <!-- Main wrapper - style you can find in pages.scss -->
        <!-- ============================================================== -->
        <div id="main-wrapper">
            <!-- ============================================================== -->
            <!-- Topbar header - style you can find in pages.scss -->
            <!-- ============================================================== -->
            <header class="topbar">
                @include('includes.admin.header')
            </header>
            <!-- ============================================================== -->
            <!-- End Topbar header -->
            <!-- ============================================================== -->
            <!-- ============================================================== -->
            <!-- Left Sidebar - style you can find in sidebar.scss  -->
            <!-- ============================================================== -->
            <aside class="left-sidebar">
                @include('includes.admin.sidebar')
            </aside>
            <!-- ============================================================== -->
            <!-- End Left Sidebar - style you can find in sidebar.scss  -->
            <!-- ============================================================== -->
            <!-- ============================================================== -->
            <!-- Page wrapper  -->
            <!-- ============================================================== -->
            <div class="page-wrapper">
                <!-- ============================================================== -->
                <!-- Container fluid  -->
                <!-- ============================================================== -->
                <div class="container-fluid">
                  <!-- ============================================================== -->
                  <!-- Bread crumb and right sidebar toggle -->
                  <!-- ============================================================== -->
                  <div class="row page-titles">
                      <div class="col-md-5 col-8 align-self-center">
                          <h3 class="text-themecolor">{{ $pagetitle }}</h3>
                          <ol class="breadcrumb">
                              <li class="breadcrumb-item"><a href="/admin">Home</a></li>
                              @yield('breadcrumbs')
                              <li class="breadcrumb-item active">{{ $pagetitle }}</li>
                          </ol>
                      </div>
                      <div class="col-md-7 col-4 align-self-center">
                          <div class="d-flex m-t-10 justify-content-end">
                              @if(!empty($OrderStats['monthlyStats']))
                                @foreach($OrderStats['monthlyStats'] as $Month => $stats)
                                <div class="d-flex m-r-20 m-l-10 hidden-xs-down">
                                    <div class="chart-text m-r-10">
                                        <h6 class="m-b-0"><small>{{ date('M Y', strtotime($Month)) }}</small></h6>
                                        <h4 class="m-t-0 text-info">£{{ array_sum($stats) }}</h4></div>
                                </div>
                                @endforeach
                              @endif
                              <div class="">
                                  <button class="right-side-toggle waves-effect waves-light btn-success btn btn-circle btn-sm pull-right m-l-10"><i class="ti-settings text-white"></i></button>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- End Bread crumb and right sidebar toggle -->
                  <!-- ============================================================== -->
                    @yield('content')
                    <!-- ============================================================== -->
                    <!-- Right sidebar -->
                    <!-- ============================================================== -->
                    <!-- .right-sidebar -->
                    <div class="right-sidebar">
                        @include('includes.admin.right-sidebar')
                    </div>
                    <!-- ============================================================== -->
                    <!-- End Right sidebar -->
                    <!-- ============================================================== -->
                </div>
                <!-- ============================================================== -->
                <!-- End Container fluid  -->
                <!-- ============================================================== -->
                <!-- ============================================================== -->
                <!-- footer -->
                <!-- ============================================================== -->
                <footer class="footer"> &COPY; {{ date('Y') }} Just Buy Plastic Admin by badsheepdesigns.co.uk </footer>
                <!-- ============================================================== -->
                <!-- End footer -->
                <!-- ============================================================== -->
            </div>
            <!-- ============================================================== -->
            <!-- End Page wrapper  -->
            <!-- ============================================================== -->
        </div>
        <!-- ============================================================== -->
        <!-- End Wrapper -->
        <!-- ============================================================== -->
        <!-- ============================================================== -->
        <!-- All Jquery -->
        <!-- ============================================================== -->
        @include('includes.admin.footer-scripts')
    </body>

</html>
