@extends('layouts.shop')

@section('meta')
<title>Basket | Plastic Supplier in Bolton, UK</title>
<meta name="description" content="Basket | Just Buy Plastic is a five-star rated plastic supplier based in Bolton, offering you everything from acrylic sheets to polycarbonate, PVC and even nylon. Buy online today!">
@endsection

@section('ogmeta')
<meta property="og:title" content="Basket | Just Buy Plastic | Plastic Supplier in Bolton, UK">
<meta property="og:description" content="Basket | Just Buy Plastic is a five-star rated plastic supplier based in Bolton, offering you everything from acrylic sheets to polycarbonate, PVC and even nylon. Buy online today!">
@endsection

@section('pre-custom-css')
<link rel="stylesheet" href="/assets/plugins/sweetalert/sweetalert.css">
@endsection

@section('css')
<link rel="stylesheet" href="/assets/css/checkoutv2.css?v={{ $VERSION }}">
@endsection

@section('js')
<script src="/assets/plugins/sweetalert/sweetalert.min.js"></script>
<script src="/assets/js/checkout.js"></script>
@endsection

@section('content')
<section id="body-basket" class=basket>
  <div class="row">
                <div class="col-sm-12"><hr class="hr-tb"></div>
                <!-- <div class="col-sm-12">
                    <p class="breadcrumb" itemprop="breadcrumb"><a href="{{ $REFERER }}" id=back>Back to Previous Page</a></p>
                </div> -->
            </div>
            <div id="mobile-items-cart"></div>
            <div class="row">
                <div class="col-md-9">
                    <div class="row">
                        <div class="col-sm-12">
                            <div id="mobile-cart" >
                                  @if(!empty($Checkout))
                                    @foreach($Checkout as $BasketItem)
                                      @if(!empty($BasketItem->Product->name))
                                      <div class="pro-selected row">
                                        <div class="col-xs-4 col-ms-3 pro-img"><img alt="{{ $BasketItem->Product->name }}" src="{{ $BasketItem->Images[0]->path_small }}"></div>
                                        <div class="col-xs-8 col-ms-9"><div class="row">
                                                <div class="col-ms-8"><p class="prod-name"><b>{{ $BasketItem->Product->name }} X {{ $BasketItem->Quantity }}</b></p>
                                                    <p class=msg>Colour: {{ $BasketItem->Color->name }}</p>
                                                    <p class=msg>Sizes: {{ $BasketItem->Width }}{{ $BasketItem->Dimension }} - {{ $BasketItem->Length }}{{ $BasketItem->Dimension }}</p>
                                                    <p class=msg>Thickness: {{ $BasketItem->Thickness->name }}</p>
                                                    <p class=ins>Special Requests<span>{{ $BasketItem->specialRequests }}</span></p>
                                                    <div class="new-del"></div>
                                                </div>
                                                <div class="col-ms-4 del-edit-price">
                                                    <div class="delete" data-pn="{{ $BasketItem->Product->name }}" data-token="{{ $BasketItem->childToken }}">
                                                        <a href="#"><i class="fa fa-times-circle"></i></a>
                                                    </div>
                                                    <p class="price lato">&pound;{{ $BasketItem->Price }}</p>
                                                </div>
                                            </div>
                                            <!--<div class="edit"><a href="/cart/edit/0/">edit item</a></div> -->
                                        </div>
                                    </div>
                                    @endif
                                  @endforeach
                                @endif

                                @if(empty($Totals->Total ))
                                  <div class="pro-selected panel panel-default basket-empty">
                                    <div class="panel-heading">Your shopping basket is empty</div>
                                        <div class="panel-body"><p class="text-center"><i class="fa fa-shopping-cart fa-5x"></i></p></div>
                                </div>
                                @endif
                              </div>
                           <!--<div id="addonproducts" class="md-ns">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <p class="rec-addon"><b>Recommended Add ons</b></p>
                                    </div>
                                </div>
                                <div class="row row-mar-lr-30">
                                    <div class="addonproducts-arrow addonproducts-arrow-left" data-pos="left"><i class="fa fa-caret-left"></i></div>
                                    <div class="addonproducts-arrow addonproducts-arrow-right" data-pos="right"><i class="fa fa-caret-right"></i></div>
                                    <div class="col-md-4 col-sm-6 col-ms-6">
                                        <div class="div-products">
                                            <h3>
                                                <a href="/flowers-by-veronica-f328954/flowers/chocolates-p164529/" title="Chocolates" rel="nofollow">
                                                    <span class="pimg"><img src="http://d2fimg.com/flowers-s17b-0.jpg" alt="Chocolates"></span>
                                                    <b>Chocolates</b>
                                                </a>
                                            </h3>
                                            <b class=price><span class=currsym>NZ&#36;</span><span class=curr data-d2f-curr="25.00">25.00</span></b>
                                            <span class="tax">including delivery</span>
                                            <a class="btn btnGrey" href="/flowers-by-veronica-f328954/flowers/chocolates-p164529/" rel=nofollow><i class="fa fa-plus-circle"></i><b>Add on item</b></a>
                                        </div>
                                    </div>
                                    <div  class="col-md-4 col-sm-6 col-ms-6">
                                        <div class="div-products">
                                            <h3>
                                                <a href="/flowers-by-veronica-f328954/flowers/roses-roses-roses-p194469/" title="Roses Roses Roses" rel="nofollow">
                                                    <span class=pimg><img src="http://d2fimg.com/d2f/157s-0.jpg" alt="Roses Roses Roses"></span>
                                                    <b>Roses Roses Roses</b>
                                                </a>
                                            </h3>
                                            <b class=price><span class=currsym>NZ&#36;</span><span class=curr data-d2f-curr="90.00">90.00</span></b>
                                            <span class="tax">including delivery</span>
                                            <a class="btn btnGrey" href="/flowers-by-veronica-f328954/flowers/roses-roses-roses-p194469/" rel=nofollow><i class="fa fa-plus-circle"></i><b>Add on item</b></a>
                                        </div>
                                    </div> <div  class="col-md-4 col-sm-6 col-ms-6">
                                        <div class="div-products">
                                            <h3>
                                                <a href="/flowers-by-veronica-f328954/flowers/chocolates-p164529/" title="Chocolates" rel="nofollow">
                                                    <span class="pimg"><img src="http://d2fimg.com/flowers-s17b-0.jpg" alt="Chocolates"></span>
                                                    <b>Chocolates</b>
                                                </a>
                                            </h3>
                                            <b class=price><span class=currsym>NZ&#36;</span><span class=curr data-d2f-curr="25.00">25.00</span></b>
                                            <span class="tax">including delivery</span>
                                            <a class="btn btnGrey" href="/flowers-by-veronica-f328954/flowers/chocolates-p164529/" rel=nofollow><i class="fa fa-plus-circle"></i><b>Add on item</b></a>
                                        </div>
                                    </div><div  class="col-md-4 col-sm-6 col-ms-6 hidden">
                                        <div class="div-products">
                                            <h3>
                                                <a href="/flowers-by-veronica-f328954/flowers/roses-roses-roses-p194469/" title="Roses Roses Roses" rel="nofollow">
                                                    <span class=pimg><img src="http://d2fimg.com/d2f/157s-0.jpg" alt="Roses Roses Roses"></span>
                                                    <b>Roses Roses Roses</b>
                                                </a>
                                            </h3>
                                            <b class=price><span class=currsym>NZ&#36;</span><span class=curr data-d2f-curr="90.00">90.00</span></b>
                                            <span class="tax">including delivery</span>
                                            <a class="btn btnGrey" href="/flowers-by-veronica-f328954/flowers/roses-roses-roses-p194469/" rel=nofollow><i class="fa fa-plus-circle"></i><b>Add on item</b></a>
                                        </div>
                                    </div>
                                </div></div>-->
                        </div></div>
                </div>
                <div class="col-md-3">
                    <div id="cart-box" class="small-12">
                        <div class="cart-total">
                            <div class="top-lock"><i class="fa fa-lock"></i></div>
                            <h4>Secure Checkout</h4>
                            <div class="cart-total-tabs tab-whb">Total Items: <span class="price lato">x {{ $BASKET }}</span></div>
                            <div class="cart-total-tabs">Total Price: <span class="price lato">&pound;{{ $Totals->ProductTotal }}</span></div>
                            <div class="cart-total-tabs">Delivery: <span class="price lato">&pound;{{ $Totals->Delivery }}</span></div>
                            <div class="cart-total-tabs">VAT: <span class="price lato">&pound;{{ $Totals->Vat }}</span></div>
                            <div class="cart-total-tabs you-pay">Total Inc VAT: <span class="price lato">&pound;{{ $Totals->Total }}</span></div>
                            <div class="cart-checkout small-12">
                                <!-- <p class="incdel">(includes delivery)</p> -->
                                @if(!empty($Totals->Vat))<form action="/checkout/1/" method=post>
                                    <button class="submit btn btn-primary" name=checkout type=submit value=1><b>Proceed to Checkout</b></button>
                                    <div class="or-hr"><hr></div>
                                    <img src="/assets/images/cards.jpg">
                                </form> @endif</div> </div>
                        <div class="cart-add-another small-12"> <a class="cart-add-another-link" href="/products/"><i class="fa fa-plus"></i>&nbsp;&nbsp;Add another item</a> </div></div>
                </div>
            </div>
</section>
@endsection
