@extends('layouts.shop')

@section('meta')
<title>{{ $Product->name }} | Just Buy Plastic | Plastic Supplier in Bolton, UK</title>
<meta name="description" content="{{ $Product->name }} | Just Buy Plastic is a five-star rated plastic supplier based in Bolton, offering you everything from acrylic sheets to polycarbonate, PVC and even nylon. Buy online today!">
@endsection

@section('ogmeta')
<meta property="og:title" content="{{ $Product->name }} | Just Buy Plastic | Plastic Supplier in Bolton, UK">
<meta property="og:description" content="{{ $Product->name }} | Just Buy Plastic is a five-star rated plastic supplier based in Bolton, offering you everything from acrylic sheets to polycarbonate, PVC and even nylon. Buy online today!">
@endsection

@section('css')

@endsection

@section('js')
<script src="/assets/js/plastic-product.js"></script>
@endsection

@section('modal')
<div class="modal fade" id="colorModal"  tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title">Modal title</h4>
      </div>
      <div class="modal-body">
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
      </div>
    </div><!-- /.modal-content -->
  </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
@endsection

@section('content')
<div class="row">
    <div class="col-lg-7 col-md-6 col-pad-l-5">
      <ol class="breadcrumb">
        <li><a href="/">Home</a></li>
        <li><a href="/plastic-types/{{ $Category->id }}/{{ str_slug($Category->name) }}">{{ $Category->name }}</a></li>
        <li class="active">{{ $Product->name }}</li>
      </ol>
      <div class="ProductCategory">
        <h2>{{ $Product->name }}</h2>
      </div>
      @if( $Product->images->count() === 3)
      <div class="row col-mar-t-10">
        <div class="col-ms-8 col-xs-12 prod-img-main">
          <div class="product-gal-img full-width">
            <div class="product-preview-inner" title="{{ $Product->name }}" style="background-image: url(/{{ $Product->images[0]->path_medium }});"></div>
          </div>
        </div>
        <div class="col-ms-4 prod-img-extra">
          <div class="row">
            <div class="col-ms-12 col-xs-6 img-extra-first">
              <div class="product-gal-img full-width">
                <div class="product-preview-inner" title="{{ $Product->name }}" style="background-image: url(/{{ $Product->images[1]->path_medium }});"></div>
              </div>
            </div>
            <div class="col-ms-12 col-xs-6 img-extra-second">
              <div class="product-gal-img full-width">
                <div class="product-preview-inner" title="{{ $Product->name }}" style="background-image: url(/{{ $Product->images[2]->path_medium }});"></div>
              </div>
            </div>
          </div>
        </div>
      </div>
      @elseif( $Product->images->count() === 2)
      <div class="row col-mar-t-10">
        <div class="col-md-6">
          <img class="full-width" src="/{{ $Product->images[0]->path_medium }}" />
        </div>
        <div class="col-md-6">
          <img class="full-width" src="/{{ $Product->images[1]->path_medium }}" />
        </div>
      </div>
      @elseif( $Product->images->count() === 1)
      <div class="row col-mar-t-10">
        <div class="col-md-12">
          <img class="full-width" src="/{{ $Product->images[0]->path_medium }}" />
        </div>
      </div>
      @endif
      @if(!empty($ProductColors))
        <div class="row col-mar-t-10">
          @foreach($ProductColors as $ColorFiles)
          <div data-toggle="modal" data-id="{{ $ColorFiles->ColorID }}" data-target="#colorModal" class="col-md-{{$colCount}} col-sm-2  col-xs-4 product-colors-pad">
            <div class="product-colors-img full-width" >
                <div class="product-preview-inner" style="background-image: url(/{{ $ColorFiles->path_medium }});"></div>
              </div>
          </div>
          @endforeach
        </div>
      @endif
      <div class="ProductCategory">
        <p>{!! nl2br(e($Product->description)) !!}</p>
      </div>
      <section id="bestSellers">
          <div class="row">
              <div class="col-sm-6 col-pad-lr-10 hidden-xs">
                  <h4>Below are a few Similar Products</h4>
              </div>
              <div class="col-sm-12 col-pad-lr-10 hidden-xs">
                  <hr>
              </div>
          </div>
          <div class="row">
            @foreach ($Similar as $Products)
              <div class="col-md-4 col-sm-6 col-ms-6 col-pad-lr-10">
                  <div class="home-gallery" data-link="https://www.justbuyplastic.co.uk{{ $Products->link }}">
                      <div class="product-gal-img-acc">
                        <div class="img-preview-inner" title="{{ $Products->name }}" style="background-image: url(/{{ $Products->mainImg }});"></div>
                          <div class="hs-box hidden"></div>
                      </div>
                      <div class="home-gal-text">
                          <h4 class="product-title">{{ $Products->name }}</h4>
                          <p>{{ $Products->short_description }}...</p>
                          <!-- <p class="home-gal-price">from <span class="price"><span class=currsym>&pound;</span>
                                  <span class=curr data-d2f-curr="27.00">27.00</span></span></p> -->
                      </div>
                  </div>
              </div>
              @endforeach
          </div>
      </section>
    </div>
    <div class="col-lg-5 col-md-6 col-pad-l-5">
      @include('includes.shop.product-quote');
    </div>
</div>
 <! --- End Best Sellers Section --->
@endsection
