<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Shop Pages
Route::get('/', 'HomeController@index');
Route::get('/products', 'HomeController@allproduct');
Route::get('/plastic-types/{id}/{CategoryName}', 'HomeController@category');
Route::get('/plastic-product/{id}/{productName}', 'HomeController@product');
Route::get('/uses/{uses}', 'HomeController@uses');
Route::get('/test-email', 'HomeController@testEmail');

//Check out
Route::get('/cookie/{token}', 'CheckoutController@setCookie');
Route::get('/basket', 'CheckoutController@basket');
Route::get('/checkout/{stage}', 'CheckoutController@stages');

Route::post('/checkout/{stage}', 'CheckoutController@postStages');

// Admin Pages
Auth::routes();
Route::get('/admin', 'AdminController@index')->name('admin');
Route::get('/admin/blank', 'AdminController@blank');
Route::get('/admin/invoice', 'AdminController@invoice');
Route::get('/admin/calendar', 'AdminController@calendar');
Route::get('/admin/timeline', 'AdminController@timeline');
Route::get('/admin/sweet', 'AdminController@sweet');
Route::get('/admin/orders', 'AdminController@allOrders');
Route::get('/admin/orders/{salesID}', 'AdminController@order');
Route::get('/admin/gallery', 'AdminController@gallery');
Route::get('/admin/products', 'AdminController@products');
Route::get('/admin/product/colors', 'AdminController@productColors');
Route::get('/admin/product/categories', 'AdminController@productCategories');
Route::get('/admin/product/thickness', 'AdminController@productThickness');
Route::get('/admin/product/shapes', 'AdminController@productShapes');
Route::get('/admin/product/holetypes', 'AdminController@holeTypes');
Route::get('/logout', 'AdminController@logout');

// Global Pages
Route::get('/{globalpages}', 'HomeController@pages');

// Post
Route::post('/admin/products', 'ProductsController@AddNewProduct');
Route::post('/admin/product/thickness', 'ProductsController@AddNewThinkness');
Route::post('/admin/product/categories', 'ProductsController@AddNewCategory');
Route::post('/admin/product/colors', 'ProductsController@AddNewColor');
Route::post('/admin/product/shapes', 'ProductsController@AddNewShape');
Route::post('/admin/product/holetypes', 'ProductsController@AddNewHT');

// Update
Route::put('/admin/product/colors', 'ProductsController@UpdateColors');
Route::put('/admin/products', 'ProductsController@UpdateProductInfo');
Route::put('/admin/product/shapes', 'ProductsController@UpdateShape');
Route::put('/admin/product/categories', 'ProductsController@UpdateProductCategory');
Route::put('/admin/product/holetypes', 'HoletypeController@UpdateHT');
